/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.BlockBody;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;

public final class Block {
    private final BlockHeader header;
    private final BlockBody body;

    public static Block fromBytes(Bytes encoded) {
        return (Block)RLP.decodeList((Bytes)encoded, Block::readFrom);
    }

    public static Block fromHexString(String str) {
        return (Block)RLP.decodeList((Bytes)Bytes.fromHexString((CharSequence)str), Block::readFrom);
    }

    public static Block readFrom(RLPReader reader) {
        BlockHeader header = (BlockHeader)reader.readList(BlockHeader::readFrom);
        BlockBody body = BlockBody.readFrom(reader);
        return new Block(header, body);
    }

    public Block(BlockHeader header, BlockBody body) {
        Objects.requireNonNull(header);
        Objects.requireNonNull(body);
        this.header = header;
        this.body = body;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public BlockHeader getHeader() {
        return this.header;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return com.google.common.base.Objects.equal((Object)this.header, (Object)other.header) && com.google.common.base.Objects.equal((Object)this.body, (Object)other.body);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.header, this.body});
    }

    public String toString() {
        return "Block{header=" + this.header + ", body=" + this.body + "}";
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::writeTo);
    }

    public void writeTo(RLPWriter writer) {
        writer.writeList(this.header::writeTo);
        this.body.writeTo(writer);
    }
}

