/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethstats;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.kotlin.core.http.HttpServerKt;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.eth.EthJsonModule;
import org.apache.tuweni.ethstats.BlockStats;
import org.apache.tuweni.ethstats.EthStatsReporter;
import org.apache.tuweni.ethstats.EthStatsServer;
import org.apache.tuweni.ethstats.EthStatsServer$sam$io_vertx_core_Handler$0;
import org.apache.tuweni.ethstats.EthStatsServerController;
import org.apache.tuweni.ethstats.NodeInfo;
import org.apache.tuweni.ethstats.NodeStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 (2\u00020\u0001:\u0001(BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020!H\u0002J\u0011\u0010%\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u0011\u0010'\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsServer;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "networkInterface", "", "port", "", "secret", "timeSupplier", "Lkotlin/Function0;", "Ljava/time/Instant;", "controller", "Lorg/apache/tuweni/ethstats/EthStatsServerController;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;Lorg/apache/tuweni/ethstats/EthStatsServerController;Lkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getNetworkInterface", "()Ljava/lang/String;", "getPort", "()I", "setPort", "(I)V", "getSecret", "server", "Lio/vertx/core/http/HttpServer;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connect", "", "serverWebSocket", "Lio/vertx/core/http/ServerWebSocket;", "handleMessage", "message", "websocket", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "Companion", "ethstats"})
public final class EthStatsServer
implements CoroutineScope {
    private HttpServer server;
    private final AtomicBoolean started;
    private final Vertx vertx;
    @NotNull
    private final String networkInterface;
    private int port;
    @NotNull
    private final String secret;
    private final Function0<Instant> timeSupplier;
    private final EthStatsServerController controller;
    @NotNull
    private final CoroutineContext coroutineContext;
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper mapper;
    @NotNull
    public static final Companion Companion;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ EthStatsServer this$0;
                Object L$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = ethStatsServer;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.started.compareAndSet(false, true)) ** GOTO lbl29
                var3_5 = this;
                var2_6 = (Function1)new Function1<ServerWebSocket, Unit>(this){

                    public final void invoke(@NotNull ServerWebSocket p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        ((EthStatsServer)this.receiver).connect(p1);
                    }
                };
                v0 = this.vertx.createHttpServer().webSocketHandler((Handler)new EthStatsServer$sam$io_vertx_core_Handler$0(var2_6)).exceptionHandler((Handler)start.3.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"vertx.createHttpServer()\u2026on occurred\", it)\n      }");
                $continuation.L$0 = var3_5;
                $continuation.label = 1;
                v1 = HttpServerKt.listenAwait((HttpServer)v0, (int)this.port, (String)this.networkInterface, (Continuation)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                var3_5 = (EthStatsServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                var4_7 = v1;
                var3_5.server = (HttpServer)var4_7;
lbl29:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof stop.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ EthStatsServer this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = ethStatsServer;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.started.compareAndSet(true, false)) break;
                v0 = this.server;
                if (v0 == null) break;
                var2_5 = v0;
                $continuation.label = 1;
                v1 = HttpServerKt.closeAwait((HttpServer)var2_5, (Continuation)$continuation);
                if (v1 == var5_4) {
                    return var5_4;
                }
                break;
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void connect(@NotNull ServerWebSocket serverWebSocket) {
        Intrinsics.checkNotNullParameter((Object)serverWebSocket, (String)"serverWebSocket");
        logger.debug("New connection");
        ServerWebSocket websocket = serverWebSocket;
        websocket.accept();
        websocket.exceptionHandler((Handler)new Handler<Throwable>(websocket){
            final /* synthetic */ ServerWebSocket $websocket;

            public final void handle(Throwable it) {
                EthStatsServer.Companion.getLogger().debug("Error reading message", it);
                this.$websocket.close();
            }
            {
                this.$websocket = serverWebSocket;
            }
        });
        websocket.textMessageHandler((Handler)new Handler<String>(this, websocket){
            final /* synthetic */ EthStatsServer this$0;
            final /* synthetic */ ServerWebSocket $websocket;

            public final void handle(String it) {
                try {
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                    EthStatsServer.access$handleMessage(this.this$0, string, this.$websocket);
                }
                catch (IOException e) {
                    EthStatsServer.Companion.getLogger().debug("Invalid payload", (Throwable)e);
                    this.$websocket.close();
                }
            }
            {
                this.this$0 = ethStatsServer;
                this.$websocket = serverWebSocket;
            }
        });
    }

    private final void handleMessage(String message, ServerWebSocket websocket) {
        logger.debug("Received {}", (Object)message);
        JsonNode jsonNode = mapper.readTree(message).get("emit");
        if (jsonNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
        }
        ArrayNode event = (ArrayNode)jsonNode;
        String command = event.get(0).textValue();
        String string = command;
        if (Intrinsics.areEqual((Object)string, (Object)"hello")) {
            String clientSecret = event.get(1).get("secret").textValue();
            if (Intrinsics.areEqual((Object)clientSecret, (Object)this.secret) ^ true) {
                logger.info("Client {} connected with wrong secret {}, disconnecting", (Object)websocket.remoteAddress(), (Object)clientSecret);
                websocket.close();
                return;
            }
            websocket.writeTextMessage("{\"emit\":[\"ready\"]}");
            String id = event.get(1).get("id").textValue();
            NodeInfo nodeInfo = (NodeInfo)mapper.readerFor(NodeInfo.class).readValue(event.get(1).get("info"));
            String string2 = websocket.remoteAddress().toString();
            String string3 = id;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id");
            NodeInfo nodeInfo2 = nodeInfo;
            Intrinsics.checkNotNullExpressionValue((Object)nodeInfo2, (String)"nodeInfo");
            this.controller.readNodeInfo(string2, string3, nodeInfo2);
            websocket.closeHandler((Handler)new Handler<Void>(this, websocket, id){
                final /* synthetic */ EthStatsServer this$0;
                final /* synthetic */ ServerWebSocket $websocket;
                final /* synthetic */ String $id;

                public final void handle(Void it) {
                    EthStatsServerController ethStatsServerController = EthStatsServer.access$getController$p(this.this$0);
                    String string = this.$websocket.remoteAddress().toString();
                    String string2 = this.$id;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
                    ethStatsServerController.readDisconnect(string, string2);
                }
                {
                    this.this$0 = ethStatsServer;
                    this.$websocket = serverWebSocket;
                    this.$id = string;
                }
            });
        } else if (Intrinsics.areEqual((Object)string, (Object)"node-ping")) {
            logger.debug("Received a ping {}", (Object)event.get(1));
            long clientTime = event.get(1).get("clientTime").longValue();
            Map payload = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"clientTime", (Object)clientTime), new Pair((Object)"serverTime", (Object)((Instant)this.timeSupplier.invoke()).toEpochMilli())});
            String response = mapper.writer().writeValueAsString((Object)MapsKt.mapOf((Pair)new Pair((Object)"emit", (Object)CollectionsKt.listOf((Object[])new Object[]{"node-pong", payload}))));
            EthStatsReporter.Companion.getLogger().debug("Sending {} message {}", (Object)command, (Object)message);
            websocket.writeTextMessage(response);
        } else if (Intrinsics.areEqual((Object)string, (Object)"latency")) {
            String id = event.get(1).get("id").textValue();
            long latency = event.get(1).get("latency").longValue();
            String string4 = websocket.remoteAddress().toString();
            String string5 = id;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"id");
            this.controller.readLatency(string4, string5, latency);
        } else if (Intrinsics.areEqual((Object)string, (Object)"end")) {
            String id = event.get(1).get("id").textValue();
            String string6 = websocket.remoteAddress().toString();
            String string7 = id;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"id");
            this.controller.readDisconnect(string6, string7);
        } else if (Intrinsics.areEqual((Object)string, (Object)"stats")) {
            String id = event.get(1).get("id").textValue();
            NodeStats nodeStats = (NodeStats)mapper.readerFor(NodeStats.class).readValue(event.get(1).get("stats"));
            String string8 = websocket.remoteAddress().toString();
            String string9 = id;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"id");
            NodeStats nodeStats2 = nodeStats;
            Intrinsics.checkNotNullExpressionValue((Object)nodeStats2, (String)"nodeStats");
            this.controller.readNodeStats(string8, string9, nodeStats2);
        } else if (Intrinsics.areEqual((Object)string, (Object)"pending")) {
            String id = event.get(1).get("id").textValue();
            long pendingTx = event.get(1).get("stats").get("pending").longValue();
            String string10 = websocket.remoteAddress().toString();
            String string11 = id;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"id");
            this.controller.readPendingTx(string10, string11, pendingTx);
        } else if (Intrinsics.areEqual((Object)string, (Object)"block")) {
            String id = event.get(1).get("id").textValue();
            BlockStats block = (BlockStats)mapper.readerFor(BlockStats.class).readValue(event.get(1).get("block"));
            String string12 = websocket.remoteAddress().toString();
            String string13 = id;
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"id");
            BlockStats blockStats = block;
            Intrinsics.checkNotNullExpressionValue((Object)blockStats, (String)"block");
            this.controller.readBlock(string12, string13, blockStats);
        } else if (!Intrinsics.areEqual((Object)string, (Object)"update") && !Intrinsics.areEqual((Object)string, (Object)"history")) {
            logger.error("Unknown command: {}", (Object)message);
            websocket.close();
        }
    }

    @NotNull
    public final String getNetworkInterface() {
        return this.networkInterface;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getSecret() {
        return this.secret;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public EthStatsServer(@NotNull Vertx vertx, @NotNull String networkInterface, int port, @NotNull String secret, @NotNull Function0<Instant> timeSupplier, @NotNull EthStatsServerController controller, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter(timeSupplier, (String)"timeSupplier");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.networkInterface = networkInterface;
        this.port = port;
        this.secret = secret;
        this.timeSupplier = timeSupplier;
        this.controller = controller;
        this.coroutineContext = coroutineContext;
        this.started = new AtomicBoolean(false);
    }

    public /* synthetic */ EthStatsServer(Vertx vertx, String string, int n, String string2, Function0 function0, EthStatsServerController ethStatsServerController, CoroutineContext coroutineContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n2 & 0x40) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(vertx, string, n, string2, (Function0<Instant>)function0, ethStatsServerController, coroutineContext);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(EthStatsServer.class);
        mapper = new ObjectMapper();
        mapper.registerModule((Module)new EthJsonModule());
    }

    public static final /* synthetic */ void access$handleMessage(EthStatsServer $this, String message, ServerWebSocket websocket) {
        $this.handleMessage(message, websocket);
    }

    public static final /* synthetic */ EthStatsServerController access$getController$p(EthStatsServer $this) {
        return $this.controller;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsServer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "ethstats"})
    public static final class Companion {
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

