/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.discovery;

import com.google.common.net.InetAddresses;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.scuttlebutt.discovery.LocalIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScuttlebuttLocalDiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(ScuttlebuttLocalDiscoveryService.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Vertx vertx;
    private final List<Consumer<LocalIdentity>> listeners = new ArrayList<Consumer<LocalIdentity>>();
    private final List<LocalIdentity> identities = new ArrayList<LocalIdentity>();
    private final int listenPort;
    private final int broadcastPort;
    private final String listenNetworkInterface;
    private final String multicastAddress;
    private DatagramSocket udpSocket;
    private long timerId;

    public ScuttlebuttLocalDiscoveryService(Vertx vertx, int listenPort, String listenNetworkInterface, String multicastAddress) {
        this(vertx, listenPort, listenPort, listenNetworkInterface, multicastAddress, true);
    }

    ScuttlebuttLocalDiscoveryService(Vertx vertx, int listenPort, int broadcastPort, String listenNetworkInterface, String multicastAddress, boolean validateMulticast) {
        InetAddress multicastIP;
        if (validateMulticast && !(multicastIP = InetAddresses.forString((String)multicastAddress)).isMulticastAddress()) {
            throw new IllegalArgumentException("Multicast address required, got " + multicastAddress);
        }
        this.vertx = vertx;
        this.listenPort = listenPort;
        this.broadcastPort = broadcastPort;
        this.listenNetworkInterface = listenNetworkInterface;
        this.multicastAddress = multicastAddress;
    }

    public AsyncCompletion start() {
        if (this.started.compareAndSet(false, true)) {
            CompletableAsyncCompletion started = AsyncCompletion.incomplete();
            this.udpSocket = this.vertx.createDatagramSocket();
            this.udpSocket.handler(this::listen).listen(this.listenPort, this.listenNetworkInterface, handler -> {
                if (handler.failed()) {
                    started.completeExceptionally(handler.cause());
                } else {
                    started.complete();
                }
            });
            this.timerId = this.vertx.setPeriodic(60000L, time -> this.broadcast());
            return started;
        }
        return AsyncCompletion.completed();
    }

    void listen(DatagramPacket datagramPacket) {
        logger.debug("Received new packet from {}", (Object)datagramPacket.sender());
        Buffer buffer = datagramPacket.data();
        if (buffer.length() > 100) {
            logger.debug("Packet too long, disregard");
            return;
        }
        String packetString = buffer.toString();
        try {
            LocalIdentity id = LocalIdentity.fromString(packetString);
            for (Consumer<LocalIdentity> listener : this.listeners) {
                listener.accept(id);
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug("Invalid identity payload {}", (Object)packetString);
        }
    }

    void broadcast() {
        for (LocalIdentity id : this.identities) {
            this.udpSocket.send(id.toCanonicalForm(), this.broadcastPort, this.multicastAddress, res -> {
                if (res.failed()) {
                    logger.error(res.cause().getMessage(), res.cause());
                }
            });
        }
    }

    public AsyncCompletion stop() {
        if (this.started.compareAndSet(true, false)) {
            this.vertx.cancelTimer(this.timerId);
            CompletableAsyncCompletion result = AsyncCompletion.incomplete();
            this.udpSocket.close(handler -> {
                if (handler.failed()) {
                    result.completeExceptionally(handler.cause());
                } else {
                    result.complete();
                }
            });
            return result;
        }
        return AsyncCompletion.completed();
    }

    public void addIdentityToBroadcastList(LocalIdentity identity) {
        this.identities.add(identity);
    }

    public void addListener(Consumer<LocalIdentity> listener) {
        this.listeners.add(listener);
    }
}

