/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Optional;
import org.apache.tuweni.scuttlebutt.lib.model.Author;
import org.apache.tuweni.scuttlebutt.lib.model.FeedMessage;
import org.apache.tuweni.scuttlebutt.lib.model.FeedValue;

public class FeedMessageDeserializer
extends JsonDeserializer<FeedMessage> {
    public FeedMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String key = node.get("key").asText();
        JsonNode value = node.get("value");
        JsonNode content = value.get("content");
        Optional<String> type = this.getType(content);
        return new FeedMessage(key, type, this.toFeedValue(value));
    }

    private FeedValue toFeedValue(JsonNode value) {
        JsonNode content = value.get("content");
        String previous = value.get("previous").asText();
        long sequence = value.get("sequence").asLong();
        String authorString = value.get("author").asText();
        Author author = new Author(authorString);
        long timestamp = value.get("timestamp").asLong();
        String hash = value.get("hash").asText();
        return new FeedValue(previous, author, sequence, timestamp, hash, content);
    }

    private Optional<String> getType(JsonNode content) {
        if (content.getNodeType() != JsonNodeType.STRING) {
            JsonNode type = content.get("type");
            return Optional.of(type.asText());
        }
        return Optional.empty();
    }
}

