/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.les;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.les.BlockHeadersMessage;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/apache/tuweni/les/BlockHeadersMessage;", "", "reqID", "", "bufferValue", "blockHeaders", "", "Lorg/apache/tuweni/eth/BlockHeader;", "(JJLjava/util/List;)V", "getBlockHeaders", "()Ljava/util/List;", "getBufferValue", "()J", "getReqID", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toBytes", "Lorg/apache/tuweni/bytes/Bytes;", "toString", "", "Companion", "les"})
public final class BlockHeadersMessage {
    private final long reqID;
    private final long bufferValue;
    @NotNull
    private final List<BlockHeader> blockHeaders;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Bytes toBytes() {
        Bytes bytes = RLP.encodeList((Consumer)new Consumer<RLPWriter>(this){
            final /* synthetic */ BlockHeadersMessage this$0;

            public final void accept(RLPWriter writer) {
                writer.writeLong(this.this$0.getReqID());
                writer.writeLong(this.this$0.getBufferValue());
                writer.writeList((Consumer)new Consumer<RLPWriter>(this){
                    final /* synthetic */ toBytes.1 this$0;

                    public final void accept(RLPWriter headersWriter) {
                        for (BlockHeader bh : this.this$0.this$0.getBlockHeaders()) {
                            headersWriter.writeRLP(bh.toBytes());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = blockHeadersMessage;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"RLP.encodeList { writer \u2026)\n        }\n      }\n    }");
        return bytes;
    }

    public final long getReqID() {
        return this.reqID;
    }

    public final long getBufferValue() {
        return this.bufferValue;
    }

    @NotNull
    public final List<BlockHeader> getBlockHeaders() {
        return this.blockHeaders;
    }

    public BlockHeadersMessage(long reqID, long bufferValue, @NotNull List<BlockHeader> blockHeaders) {
        Intrinsics.checkNotNullParameter(blockHeaders, (String)"blockHeaders");
        this.reqID = reqID;
        this.bufferValue = bufferValue;
        this.blockHeaders = blockHeaders;
    }

    public final long component1() {
        return this.reqID;
    }

    public final long component2() {
        return this.bufferValue;
    }

    @NotNull
    public final List<BlockHeader> component3() {
        return this.blockHeaders;
    }

    @NotNull
    public final BlockHeadersMessage copy(long reqID, long bufferValue, @NotNull List<BlockHeader> blockHeaders) {
        Intrinsics.checkNotNullParameter(blockHeaders, (String)"blockHeaders");
        return new BlockHeadersMessage(reqID, bufferValue, blockHeaders);
    }

    public static /* synthetic */ BlockHeadersMessage copy$default(BlockHeadersMessage blockHeadersMessage, long l, long l2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            l = blockHeadersMessage.reqID;
        }
        if ((n & 2) != 0) {
            l2 = blockHeadersMessage.bufferValue;
        }
        if ((n & 4) != 0) {
            list = blockHeadersMessage.blockHeaders;
        }
        return blockHeadersMessage.copy(l, l2, list);
    }

    @NotNull
    public String toString() {
        return "BlockHeadersMessage(reqID=" + this.reqID + ", bufferValue=" + this.bufferValue + ", blockHeaders=" + this.blockHeaders + ")";
    }

    public int hashCode() {
        List<BlockHeader> list = this.blockHeaders;
        return (Long.hashCode(this.reqID) * 31 + Long.hashCode(this.bufferValue)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BlockHeadersMessage)) break block3;
                BlockHeadersMessage blockHeadersMessage = (BlockHeadersMessage)object;
                if (this.reqID != blockHeadersMessage.reqID || this.bufferValue != blockHeadersMessage.bufferValue || !Intrinsics.areEqual(this.blockHeaders, blockHeadersMessage.blockHeaders)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/les/BlockHeadersMessage$Companion;", "", "()V", "read", "Lorg/apache/tuweni/les/BlockHeadersMessage;", "bytes", "Lorg/apache/tuweni/bytes/Bytes;", "les"})
    public static final class Companion {
        @NotNull
        public final BlockHeadersMessage read(@NotNull Bytes bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Object object = RLP.decodeList((Bytes)bytes, (Function)read.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RLP.decodeList(bytes) { \u2026erValue, headers)\n      }");
            return (BlockHeadersMessage)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

