/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.logging.ByteBufFormat;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.nio.charset.Charset;
import java.util.Objects;

final class ReactorNettyLoggingHandler
extends LoggingHandler {
    private final Charset charset;

    ReactorNettyLoggingHandler(String name, LogLevel level, Charset charset) {
        super(name, level);
        this.charset = Objects.requireNonNull(charset, "charset");
    }

    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        if (arg instanceof ByteBuf) {
            return this.formatByteBuf(ctx, eventName, (ByteBuf)arg);
        }
        if (arg instanceof ByteBufHolder) {
            return this.formatByteBuf(ctx, eventName, ((ByteBufHolder)arg).content());
        }
        return super.format(ctx, eventName, arg);
    }

    private String formatByteBuf(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        String chStr = ctx.channel().toString();
        int messageLength = msg.readableBytes();
        String message = msg.toString(this.charset);
        return chStr + ' ' + eventName + ": " + messageLength + "B " + message;
    }

    public ByteBufFormat byteBufFormat() {
        throw new UnsupportedOperationException("ReactorNettyLoggingHandler isn't using the classic ByteBufFormat.");
    }
}

