/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.concurrent;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.concurrent.DefaultCompletableAsyncResult;

final class DefaultCompletableAsyncCompletion
implements CompletableAsyncCompletion {
    private final CompletableFuture<Void> future;

    DefaultCompletableAsyncCompletion() {
        this(new CompletableFuture<Void>());
    }

    DefaultCompletableAsyncCompletion(CompletableFuture<Void> future) {
        this.future = future;
    }

    @Override
    public boolean complete() {
        return this.future.complete(null);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.future.completeExceptionally(ex);
    }

    @Override
    public boolean cancel() {
        return this.future.cancel(false);
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.future.isCompletedExceptionally();
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public void join() throws CompletionException, InterruptedException {
        try {
            this.join(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            throw new RuntimeException("Default timeout triggered for blocking call to AsyncCompletion::join()", ex);
        }
    }

    @Override
    public void join(long timeout, TimeUnit unit) throws CompletionException, TimeoutException, InterruptedException {
        Objects.requireNonNull(unit);
        try {
            this.future.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw new CompletionException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public <U> AsyncResult<U> then(Supplier<? extends AsyncResult<U>> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((v, ex1) -> {
            if (ex1 == null) {
                try {
                    ((AsyncResult)fn.get()).whenComplete((? super T u, ? super Throwable ex3) -> {
                        if (ex3 == null) {
                            asyncResult.complete(u);
                        } else {
                            asyncResult.completeExceptionally((Throwable)ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public <U> AsyncResult<U> thenSchedule(Vertx vertx, Supplier<? extends AsyncResult<U>> fn) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((v, ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.runOnContext(arg_0 -> DefaultCompletableAsyncCompletion.lambda$thenSchedule$3((Supplier)fn, asyncResult, arg_0));
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public AsyncCompletion thenCompose(Supplier<? extends AsyncCompletion> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((v, ex1) -> {
            if (ex1 == null) {
                try {
                    ((AsyncCompletion)fn.get()).whenComplete(ex3 -> {
                        if (ex3 == null) {
                            completion.complete();
                        } else {
                            completion.completeExceptionally((Throwable)ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public AsyncCompletion thenRun(Runnable action) {
        Objects.requireNonNull(action);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.thenRun(action));
    }

    @Override
    public AsyncCompletion thenScheduleRun(Vertx vertx, Runnable runnable) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(runnable);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((t, ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.runOnContext(ev -> {
                        try {
                            runnable.run();
                        }
                        catch (Throwable ex3) {
                            completion.completeExceptionally(ex3);
                            return;
                        }
                        completion.complete();
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public AsyncCompletion thenScheduleBlockingRun(Vertx vertx, Runnable runnable) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(runnable);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((t, ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.executeBlocking(vertxFuture -> {
                        runnable.run();
                        vertxFuture.complete(null);
                    }, false, res -> {
                        if (res.succeeded()) {
                            completion.complete();
                        } else {
                            completion.completeExceptionally(res.cause());
                        }
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public AsyncCompletion thenScheduleBlockingRun(WorkerExecutor executor, Runnable runnable) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(runnable);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((t, ex1) -> {
            if (ex1 == null) {
                try {
                    executor.executeBlocking(vertxFuture -> {
                        runnable.run();
                        vertxFuture.complete(null);
                    }, false, res -> {
                        if (res.succeeded()) {
                            completion.complete();
                        } else {
                            completion.completeExceptionally(res.cause());
                        }
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public <U> AsyncResult<U> thenSupply(Supplier<? extends U> supplier) {
        Objects.requireNonNull(supplier);
        return new DefaultCompletableAsyncResult(this.future.thenApply(v -> supplier.get()));
    }

    @Override
    public <U> AsyncResult<U> thenSupply(Vertx vertx, Supplier<? extends U> supplier) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(supplier);
        CompletableAsyncResult completion = AsyncResult.incomplete();
        this.future.whenComplete((t, ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.runOnContext(arg_0 -> DefaultCompletableAsyncCompletion.lambda$thenSupply$16(completion, (Supplier)supplier, arg_0));
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public <U> AsyncCompletion thenConsume(AsyncResult<? extends U> other, Consumer<? super U> consumer) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(consumer);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.thenAccept(v -> other.thenAccept(consumer::accept)));
    }

    @Override
    public <U, V> AsyncResult<V> thenApply(AsyncResult<? extends U> other, Function<? super U, ? extends V> fn) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((v, ex1) -> {
            if (ex1 == null) {
                try {
                    other.whenComplete((? super T u, ? super Throwable ex3) -> {
                        if (ex3 == null) {
                            asyncResult.complete(fn.apply((Object)u));
                        } else {
                            asyncResult.completeExceptionally((Throwable)ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public AsyncCompletion thenCombine(AsyncCompletion other) {
        Objects.requireNonNull(other);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((v, ex1) -> {
            if (ex1 == null) {
                try {
                    other.whenComplete(ex3 -> {
                        if (ex3 == null) {
                            completion.complete();
                        } else {
                            completion.completeExceptionally((Throwable)ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public AsyncCompletion exceptionally(Consumer<? super Throwable> consumer) {
        Objects.requireNonNull(consumer);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.exceptionally(ex -> {
            consumer.accept((Throwable)ex);
            return null;
        }));
    }

    @Override
    public AsyncCompletion whenComplete(Consumer<? super Throwable> consumer) {
        Objects.requireNonNull(consumer);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.whenComplete((v, ex) -> consumer.accept((Throwable)ex)));
    }

    @Override
    public <U> AsyncResult<U> handle(Function<? super Throwable, ? extends U> fn) {
        Objects.requireNonNull(fn);
        return new DefaultCompletableAsyncResult(this.future.handle((T v, U ex) -> fn.apply((Throwable)ex)));
    }

    @Override
    public AsyncCompletion accept(Consumer<? super Throwable> consumer) {
        Objects.requireNonNull(consumer);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.handle((T v, U ex) -> {
            consumer.accept((Throwable)ex);
            return null;
        }));
    }

    @Override
    public CompletableFuture<Void> toFuture() {
        return this.future;
    }

    private static /* synthetic */ void lambda$thenSupply$16(CompletableAsyncResult completion, Supplier supplier, Void ev) {
        try {
            completion.complete(supplier.get());
        }
        catch (Throwable ex3) {
            completion.completeExceptionally(ex3);
        }
    }

    private static /* synthetic */ void lambda$thenSchedule$3(Supplier fn, CompletableAsyncResult asyncResult, Void ev) {
        try {
            ((AsyncResult)fn.get()).whenComplete((? super T u, ? super Throwable ex4) -> {
                if (ex4 == null) {
                    asyncResult.complete(u);
                } else {
                    asyncResult.completeExceptionally((Throwable)ex4);
                }
            });
        }
        catch (Throwable ex3) {
            asyncResult.completeExceptionally(ex3);
        }
    }
}

