/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.concurrent;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.concurrent.DefaultCompletableAsyncCompletion;
import org.apache.tuweni.concurrent.DefaultCompletableAsyncResult;

public interface AsyncResult<T> {
    public static <T> AsyncResult<T> completed(@Nullable T value) {
        DefaultCompletableAsyncResult<T> result = new DefaultCompletableAsyncResult<T>();
        result.complete(value);
        return result;
    }

    public static <T> AsyncResult<T> exceptional(Throwable ex) {
        Objects.requireNonNull(ex);
        DefaultCompletableAsyncResult result = new DefaultCompletableAsyncResult();
        result.completeExceptionally(ex);
        return result;
    }

    public static <T> CompletableAsyncResult<T> incomplete() {
        return new DefaultCompletableAsyncResult();
    }

    public static AsyncCompletion allOf(AsyncResult<?> ... rs) {
        return AsyncResult.allOf(Arrays.stream(rs));
    }

    public static AsyncCompletion allOf(Collection<? extends AsyncResult<?>> rs) {
        return AsyncResult.allOf(rs.stream());
    }

    public static AsyncCompletion allOf(Stream<? extends AsyncResult<?>> rs) {
        CompletableFuture[] completableFutures = (CompletableFuture[])rs.map(result -> {
            CompletableFuture javaFuture = new CompletableFuture();
            result.whenComplete((v, ex) -> {
                if (ex == null) {
                    javaFuture.complete(null);
                } else {
                    javaFuture.completeExceptionally((Throwable)ex);
                }
            });
            return javaFuture;
        }).toArray(CompletableFuture[]::new);
        return new DefaultCompletableAsyncCompletion(CompletableFuture.allOf(completableFutures));
    }

    public static <T> AsyncResult<List<T>> combine(Collection<? extends AsyncResult<? extends T>> rs) {
        return AsyncResult.combine(rs.stream());
    }

    public static <T> AsyncResult<List<T>> combine(Stream<? extends AsyncResult<? extends T>> rs) {
        Stream<AsyncResult> ls = rs.map(r -> r.thenApply(Collections::singletonList));
        return ls.reduce(AsyncResult.completed(new ArrayList()), (r1, r2) -> r1.thenCombine((AsyncResult)r2, (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }));
    }

    public static <T> AsyncResult<T> runOnContext(Vertx vertx, Supplier<? extends AsyncResult<T>> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        vertx.runOnContext(ev -> {
            try {
                ((AsyncResult)fn.get()).whenComplete((u, ex2) -> {
                    if (ex2 == null) {
                        try {
                            asyncResult.complete(u);
                        }
                        catch (Throwable ex3) {
                            asyncResult.completeExceptionally(ex3);
                        }
                    } else {
                        asyncResult.completeExceptionally((Throwable)ex2);
                    }
                });
            }
            catch (Throwable ex1) {
                asyncResult.completeExceptionally(ex1);
            }
        });
        return asyncResult;
    }

    public static <T> AsyncResult<T> executeBlocking(Supplier<T> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                asyncResult.complete(fn.get());
            }
            catch (Throwable ex) {
                asyncResult.completeExceptionally(ex);
            }
        });
        return asyncResult;
    }

    public static <T> AsyncResult<T> executeBlocking(Executor executor, Supplier<T> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        executor.execute(() -> {
            try {
                asyncResult.complete(fn.get());
            }
            catch (Throwable ex) {
                asyncResult.completeExceptionally(ex);
            }
        });
        return asyncResult;
    }

    public static <T> AsyncResult<T> executeBlocking(Vertx vertx, Supplier<T> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        vertx.executeBlocking(future -> future.complete(fn.get()), false, res -> {
            if (res.succeeded()) {
                asyncResult.complete(res.result());
            } else {
                asyncResult.completeExceptionally(res.cause());
            }
        });
        return asyncResult;
    }

    public static <T> AsyncResult<T> executeBlocking(WorkerExecutor executor, Supplier<T> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        executor.executeBlocking(future -> future.complete(fn.get()), false, res -> {
            if (res.succeeded()) {
                asyncResult.complete(res.result());
            } else {
                asyncResult.completeExceptionally(res.cause());
            }
        });
        return asyncResult;
    }

    public boolean isDone();

    public boolean isCompletedExceptionally();

    public boolean cancel();

    public boolean isCancelled();

    @Nullable
    public T get() throws CompletionException, InterruptedException;

    @Nullable
    public T get(long var1, TimeUnit var3) throws CompletionException, TimeoutException, InterruptedException;

    public <U> AsyncResult<U> then(Function<? super T, ? extends AsyncResult<U>> var1);

    public <U> AsyncResult<U> thenSchedule(Vertx var1, Function<? super T, ? extends AsyncResult<U>> var2);

    public AsyncCompletion thenCompose(Function<? super T, ? extends AsyncCompletion> var1);

    public AsyncCompletion thenRun(Runnable var1);

    public AsyncCompletion thenScheduleRun(Vertx var1, Runnable var2);

    public AsyncCompletion thenScheduleBlockingRun(Vertx var1, Runnable var2);

    public AsyncCompletion thenScheduleBlockingRun(WorkerExecutor var1, Runnable var2);

    public <U> AsyncResult<U> thenApply(Function<? super T, ? extends U> var1);

    public <U> AsyncResult<U> thenScheduleApply(Vertx var1, Function<? super T, ? extends U> var2);

    public <U> AsyncResult<U> thenScheduleBlockingApply(Vertx var1, Function<? super T, ? extends U> var2);

    public <U> AsyncResult<U> thenScheduleBlockingApply(WorkerExecutor var1, Function<? super T, ? extends U> var2);

    public AsyncCompletion thenAccept(Consumer<? super T> var1);

    public <U> AsyncCompletion thenAcceptBoth(AsyncResult<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U, V> AsyncResult<V> thenCombine(AsyncResult<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    public AsyncResult<T> exceptionally(Function<Throwable, ? extends T> var1);

    public AsyncResult<T> whenComplete(BiConsumer<? super T, ? super Throwable> var1);

    public <U> AsyncResult<U> handle(BiFunction<? super T, Throwable, ? extends U> var1);

    public AsyncCompletion accept(BiConsumer<? super T, Throwable> var1);
}

