/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.gossip;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.Provider;
import java.security.Security;
import java.time.Instant;
import java.util.Collections;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.gossip.CountingPeerPruningFunction;
import org.apache.tuweni.gossip.GossipCommandLineOptions;
import org.apache.tuweni.gossip.LoggingPeerRepository;
import org.apache.tuweni.plumtree.PeerPruning;
import org.apache.tuweni.plumtree.PeerRepository;
import org.apache.tuweni.plumtree.vertx.VertxGossipServer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public final class GossipApp {
    private static final Logger logger = LoggerFactory.getLogger((String)GossipApp.class.getName());
    private final ExecutorService senderThreadPool = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "sender");
        t.setDaemon(false);
        return t;
    });
    private final GossipCommandLineOptions opts;
    private final Runnable terminateFunction;
    private final PrintStream errStream;
    private final PrintStream outStream;
    private final VertxGossipServer server;
    private final HttpServer rpcServer;
    private final ExecutorService fileWriter = Executors.newSingleThreadExecutor();

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        GossipCommandLineOptions opts = (GossipCommandLineOptions)CommandLine.populateCommand((Object)new GossipCommandLineOptions(), (String[])args);
        try {
            opts.validate();
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid configuration detected.\n\n{}", (Object)e.getMessage());
            new CommandLine((Object)opts).usage(System.out);
            System.exit(1);
        }
        if (opts.help()) {
            new CommandLine((Object)opts).usage(System.out);
            System.exit(0);
        }
        GossipApp gossipApp = new GossipApp(Vertx.vertx(), opts, System.err, System.out, () -> System.exit(1));
        Runtime.getRuntime().addShutdownHook(new Thread(gossipApp::stop));
        gossipApp.start();
    }

    GossipApp(Vertx vertx, GossipCommandLineOptions opts, PrintStream errStream, PrintStream outStream, Runnable terminateFunction) {
        LoggingPeerRepository repository = new LoggingPeerRepository();
        logger.info("Setting up server on {}:{}", (Object)opts.networkInterface(), (Object)opts.listenPort());
        this.server = new VertxGossipServer(vertx, opts.networkInterface(), opts.listenPort(), Hash::keccak256, (PeerRepository)repository, (bytes, attr) -> this.readMessage(opts.messageLog(), errStream, bytes), null, (PeerPruning)new CountingPeerPruningFunction(10), 100, 100);
        this.opts = opts;
        this.errStream = errStream;
        this.outStream = outStream;
        this.terminateFunction = terminateFunction;
        this.rpcServer = vertx.createHttpServer();
    }

    void start() {
        logger.info("Starting gossip");
        AsyncCompletion completion = this.server.start();
        try {
            completion.join();
        }
        catch (InterruptedException | CompletionException e) {
            logger.error("Server could not start: {}", (Object)e.getMessage());
            this.terminateFunction.run();
        }
        logger.info("TCP server started");
        CompletableAsyncCompletion rpcCompletion = AsyncCompletion.incomplete();
        this.rpcServer.requestHandler(this::handleRPCRequest).listen(this.opts.rpcPort(), this.opts.networkInterface(), res -> {
            if (res.failed()) {
                rpcCompletion.completeExceptionally(res.cause());
            } else {
                rpcCompletion.complete();
            }
        });
        try {
            rpcCompletion.join();
        }
        catch (InterruptedException | CompletionException e) {
            logger.error("RPC server could not start: " + e.getMessage());
            this.terminateFunction.run();
        }
        logger.info("RPC server started");
        try {
            AsyncCompletion.allOf(this.opts.peers().stream().map(peer -> this.server.connectTo(peer.getHost(), peer.getPort()))).join(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            this.errStream.println("Server could not connect to other peers: " + e.getMessage());
        }
        logger.info("Gossip started");
        if (this.opts.sending()) {
            logger.info("Start sending messages");
            this.senderThreadPool.submit(() -> {
                for (int i = 0; i < this.opts.numberOfMessages(); ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    Bytes payload = Bytes.random((int)this.opts.payloadSize());
                    this.publish(payload);
                    try {
                        Thread.sleep(this.opts.sendInterval().intValue());
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
        }
    }

    private void handleRPCRequest(HttpServerRequest httpServerRequest) {
        if (HttpMethod.POST.equals((Object)httpServerRequest.method())) {
            if ("/publish".equals(httpServerRequest.path())) {
                httpServerRequest.bodyHandler(body -> {
                    Bytes message = Bytes.wrapBuffer((Buffer)body);
                    this.outStream.println("Message to publish " + message.toHexString());
                    this.publish(message);
                    httpServerRequest.response().setStatusCode(200).end();
                });
            } else {
                httpServerRequest.response().setStatusCode(404).end();
            }
        } else {
            httpServerRequest.response().setStatusCode(405).end();
        }
    }

    void stop() {
        logger.info("Stopping sending");
        this.senderThreadPool.shutdown();
        logger.info("Stopping gossip");
        try {
            this.server.stop().join();
        }
        catch (InterruptedException e) {
            logger.error("Server could not stop: {}", (Object)e.getMessage());
            this.terminateFunction.run();
        }
        CompletableAsyncCompletion rpcCompletion = AsyncCompletion.incomplete();
        this.rpcServer.close(res -> {
            if (res.failed()) {
                rpcCompletion.completeExceptionally(res.cause());
            } else {
                rpcCompletion.complete();
            }
        });
        try {
            rpcCompletion.join();
        }
        catch (InterruptedException | CompletionException e) {
            logger.info("Stopped gossip");
            logger.error("RPC server could not stop: {}", (Object)e.getMessage());
            this.terminateFunction.run();
        }
        this.fileWriter.shutdown();
    }

    private void readMessage(String messageLog, PrintStream err, Bytes bytes) {
        this.fileWriter.submit(() -> {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = mapper.createObjectNode();
            node.put("timestamp", Instant.now().toString());
            node.put("value", bytes.toHexString());
            try {
                Path path = Paths.get(messageLog, new String[0]);
                Files.write(path, Collections.singletonList(mapper.writeValueAsString((Object)node)), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                err.println(e.getMessage());
            }
        });
    }

    public void publish(Bytes message) {
        this.server.gossip("", message);
    }
}

