/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.net.URI;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.DefaultServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.WebSessionOAuth2ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.savedrequest.WebSessionServerRequestCache;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class OAuth2AuthorizationRequestRedirectWebFilter
implements WebFilter {
    private final ServerRedirectStrategy authorizationRedirectStrategy = new DefaultServerRedirectStrategy();
    private final ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver;
    private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository = new WebSessionOAuth2ServerAuthorizationRequestRepository();
    private ServerRequestCache requestCache = new WebSessionServerRequestCache();

    public OAuth2AuthorizationRequestRedirectWebFilter(ReactiveClientRegistrationRepository clientRegistrationRepository) {
        this.authorizationRequestResolver = new DefaultServerOAuth2AuthorizationRequestResolver(clientRegistrationRepository);
    }

    public OAuth2AuthorizationRequestRedirectWebFilter(ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver) {
        Assert.notNull((Object)authorizationRequestResolver, (String)"authorizationRequestResolver cannot be null");
        this.authorizationRequestResolver = authorizationRequestResolver;
    }

    public final void setAuthorizationRequestRepository(ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
        Assert.notNull(authorizationRequestRepository, (String)"authorizationRequestRepository cannot be null");
        this.authorizationRequestRepository = authorizationRequestRepository;
    }

    public void setRequestCache(ServerRequestCache requestCache) {
        Assert.notNull((Object)requestCache, (String)"requestCache cannot be null");
        this.requestCache = requestCache;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.authorizationRequestResolver.resolve(exchange).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).onErrorResume(ClientAuthorizationRequiredException.class, ex -> this.requestCache.saveRequest(exchange).then(this.authorizationRequestResolver.resolve(exchange, ex.getClientRegistrationId()))).flatMap(clientRegistration -> this.sendRedirectForAuthorization(exchange, (OAuth2AuthorizationRequest)clientRegistration));
    }

    private Mono<Void> sendRedirectForAuthorization(ServerWebExchange exchange, OAuth2AuthorizationRequest authorizationRequest) {
        return Mono.defer(() -> {
            Mono<Void> saveAuthorizationRequest = Mono.empty();
            if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationRequest.getGrantType())) {
                saveAuthorizationRequest = this.authorizationRequestRepository.saveAuthorizationRequest(authorizationRequest, exchange);
            }
            URI redirectUri = UriComponentsBuilder.fromUriString((String)authorizationRequest.getAuthorizationRequestUri()).build(true).toUri();
            return saveAuthorizationRequest.then(this.authorizationRedirectStrategy.sendRedirect(exchange, redirectUri));
        });
    }
}

