/*
 * Decompiled with CFR 0.152.
 */
package com.neilalexander.jnacl.crypto;

public class curve25519 {
    final int CRYPTO_BYTES = 32;
    final int CRYPTO_SCALARBYTES = 32;
    static byte[] basev = new byte[]{9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] minusp = new int[]{19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128};

    public static int crypto_scalarmult_base(byte[] q, byte[] n) {
        byte[] basevp = basev;
        return curve25519.crypto_scalarmult(q, n, basevp);
    }

    static void add(int[] outv, int outvoffset, int[] a2, int aoffset, int[] b2, int boffset) {
        int u = 0;
        for (int j = 0; j < 31; ++j) {
            outv[outvoffset + j] = (u += a2[aoffset + j] + b2[boffset + j]) & 0xFF;
            u >>>= 8;
        }
        outv[outvoffset + 31] = u += a2[aoffset + 31] + b2[boffset + 31];
    }

    static void sub(int[] outv, int outvoffset, int[] a2, int aoffset, int[] b2, int boffset) {
        int u = 218;
        for (int j = 0; j < 31; ++j) {
            outv[outvoffset + j] = (u += a2[aoffset + j] + 65280 - b2[boffset + j]) & 0xFF;
            u >>>= 8;
        }
        outv[outvoffset + 31] = u += a2[aoffset + 31] - b2[boffset + 31];
    }

    static void squeeze(int[] a2, int aoffset) {
        int j;
        int u = 0;
        for (j = 0; j < 31; ++j) {
            a2[aoffset + j] = (u += a2[aoffset + j]) & 0xFF;
            u >>>= 8;
        }
        a2[aoffset + 31] = (u += a2[aoffset + 31]) & 0x7F;
        u = 19 * (u >>> 7);
        for (j = 0; j < 31; ++j) {
            a2[aoffset + j] = (u += a2[aoffset + j]) & 0xFF;
            u >>>= 8;
        }
        a2[aoffset + 31] = u += a2[aoffset + 31];
    }

    static void freeze(int[] a2, int aoffset) {
        int[] aorig = new int[32];
        for (int j = 0; j < 32; ++j) {
            aorig[j] = a2[aoffset + j];
        }
        int[] minuspp = minusp;
        curve25519.add(a2, 0, a2, 0, minuspp, 0);
        int negative = -(a2[aoffset + 31] >>> 7 & 1);
        for (int j = 0; j < 32; ++j) {
            int n = aoffset + j;
            a2[n] = a2[n] ^ negative & (aorig[j] ^ a2[aoffset + j]);
        }
    }

    static void mult(int[] outv, int outvoffset, int[] a2, int aoffset, int[] b2, int boffset) {
        for (int i = 0; i < 32; ++i) {
            int j;
            int u = 0;
            for (j = 0; j <= i; ++j) {
                u += a2[aoffset + j] * b2[boffset + i - j];
            }
            for (j = i + 1; j < 32; ++j) {
                u += 38 * a2[aoffset + j] * b2[boffset + i + 32 - j];
            }
            outv[outvoffset + i] = u;
        }
        curve25519.squeeze(outv, outvoffset);
    }

    static void mult121665(int[] outv, int[] a2) {
        int j;
        int u = 0;
        for (j = 0; j < 31; ++j) {
            outv[j] = (u += 121665 * a2[j]) & 0xFF;
            u >>>= 8;
        }
        outv[31] = (u += 121665 * a2[31]) & 0x7F;
        u = 19 * (u >>> 7);
        for (j = 0; j < 31; ++j) {
            outv[j] = (u += outv[j]) & 0xFF;
            u >>>= 8;
        }
        outv[j] = u += outv[j];
    }

    static void square(int[] outv, int outvoffset, int[] a2, int aoffset) {
        for (int i = 0; i < 32; ++i) {
            int j;
            int u = 0;
            for (j = 0; j < i - j; ++j) {
                u += a2[aoffset + j] * a2[aoffset + i - j];
            }
            for (j = i + 1; j < i + 32 - j; ++j) {
                u += 38 * a2[aoffset + j] * a2[aoffset + i + 32 - j];
            }
            u *= 2;
            if ((i & 1) == 0) {
                u += a2[aoffset + i / 2] * a2[aoffset + i / 2];
                u += 38 * a2[aoffset + i / 2 + 16] * a2[aoffset + i / 2 + 16];
            }
            outv[outvoffset + i] = u;
        }
        curve25519.squeeze(outv, outvoffset);
    }

    static void select(int[] p, int[] q, int[] r, int[] s, int b2) {
        int bminus1 = b2 - 1;
        for (int j = 0; j < 64; ++j) {
            int t = bminus1 & (r[j] ^ s[j]);
            p[j] = s[j] ^ t;
            q[j] = r[j] ^ t;
        }
    }

    static void mainloop(int[] work, byte[] e) {
        int j;
        int[] xzm1 = new int[64];
        int[] xzm = new int[64];
        int[] xzmb = new int[64];
        int[] xzm1b = new int[64];
        int[] xznb = new int[64];
        int[] xzn1b = new int[64];
        int[] a0 = new int[64];
        int[] a1 = new int[64];
        int[] b0 = new int[64];
        int[] b1 = new int[64];
        int[] c1 = new int[64];
        int[] r = new int[32];
        int[] s = new int[32];
        int[] t = new int[32];
        int[] u = new int[32];
        for (j = 0; j < 32; ++j) {
            xzm1[j] = work[j];
        }
        xzm1[32] = 1;
        for (j = 33; j < 64; ++j) {
            xzm1[j] = 0;
        }
        xzm[0] = 1;
        for (j = 1; j < 64; ++j) {
            xzm[j] = 0;
        }
        for (int pos = 254; pos >= 0; --pos) {
            int b2 = (e[pos / 8] & 0xFF) >>> (pos & 7);
            curve25519.select(xzmb, xzm1b, xzm, xzm1, b2 &= 1);
            curve25519.add(a0, 0, xzmb, 0, xzmb, 32);
            curve25519.sub(a0, 32, xzmb, 0, xzmb, 32);
            curve25519.add(a1, 0, xzm1b, 0, xzm1b, 32);
            curve25519.sub(a1, 32, xzm1b, 0, xzm1b, 32);
            curve25519.square(b0, 0, a0, 0);
            curve25519.square(b0, 32, a0, 32);
            curve25519.mult(b1, 0, a1, 0, a0, 32);
            curve25519.mult(b1, 32, a1, 32, a0, 0);
            curve25519.add(c1, 0, b1, 0, b1, 32);
            curve25519.sub(c1, 32, b1, 0, b1, 32);
            curve25519.square(r, 0, c1, 32);
            curve25519.sub(s, 0, b0, 0, b0, 32);
            curve25519.mult121665(t, s);
            curve25519.add(u, 0, t, 0, b0, 0);
            curve25519.mult(xznb, 0, b0, 0, b0, 32);
            curve25519.mult(xznb, 32, s, 0, u, 0);
            curve25519.square(xzn1b, 0, c1, 0);
            curve25519.mult(xzn1b, 32, r, 0, work, 0);
            curve25519.select(xzm, xzm1, xznb, xzn1b, b2);
        }
        for (j = 0; j < 64; ++j) {
            work[j] = xzm[j];
        }
    }

    static void recip(int[] outv, int outvoffset, int[] z2, int zoffset) {
        int i;
        int[] z22 = new int[32];
        int[] z9 = new int[32];
        int[] z11 = new int[32];
        int[] z2_5_0 = new int[32];
        int[] z2_10_0 = new int[32];
        int[] z2_20_0 = new int[32];
        int[] z2_50_0 = new int[32];
        int[] z2_100_0 = new int[32];
        int[] t0 = new int[32];
        int[] t1 = new int[32];
        curve25519.square(z22, 0, z2, zoffset);
        curve25519.square(t1, 0, z22, 0);
        curve25519.square(t0, 0, t1, 0);
        curve25519.mult(z9, 0, t0, 0, z2, zoffset);
        curve25519.mult(z11, 0, z9, 0, z22, 0);
        curve25519.square(t0, 0, z11, 0);
        curve25519.mult(z2_5_0, 0, t0, 0, z9, 0);
        curve25519.square(t0, 0, z2_5_0, 0);
        curve25519.square(t1, 0, t0, 0);
        curve25519.square(t0, 0, t1, 0);
        curve25519.square(t1, 0, t0, 0);
        curve25519.square(t0, 0, t1, 0);
        curve25519.mult(z2_10_0, 0, t0, 0, z2_5_0, 0);
        curve25519.square(t0, 0, z2_10_0, 0);
        curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 10; i += 2) {
            curve25519.square(t0, 0, t1, 0);
            curve25519.square(t1, 0, t0, 0);
        }
        curve25519.mult(z2_20_0, 0, t1, 0, z2_10_0, 0);
        curve25519.square(t0, 0, z2_20_0, 0);
        curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 20; i += 2) {
            curve25519.square(t0, 0, t1, 0);
            curve25519.square(t1, 0, t0, 0);
        }
        curve25519.mult(t0, 0, t1, 0, z2_20_0, 0);
        curve25519.square(t1, 0, t0, 0);
        curve25519.square(t0, 0, t1, 0);
        for (i = 2; i < 10; i += 2) {
            curve25519.square(t1, 0, t0, 0);
            curve25519.square(t0, 0, t1, 0);
        }
        curve25519.mult(z2_50_0, 0, t0, 0, z2_10_0, 0);
        curve25519.square(t0, 0, z2_50_0, 0);
        curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 50; i += 2) {
            curve25519.square(t0, 0, t1, 0);
            curve25519.square(t1, 0, t0, 0);
        }
        curve25519.mult(z2_100_0, 0, t1, 0, z2_50_0, 0);
        curve25519.square(t1, 0, z2_100_0, 0);
        curve25519.square(t0, 0, t1, 0);
        for (i = 2; i < 100; i += 2) {
            curve25519.square(t1, 0, t0, 0);
            curve25519.square(t0, 0, t1, 0);
        }
        curve25519.mult(t1, 0, t0, 0, z2_100_0, 0);
        curve25519.square(t0, 0, t1, 0);
        curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 50; i += 2) {
            curve25519.square(t0, 0, t1, 0);
            curve25519.square(t1, 0, t0, 0);
        }
        curve25519.mult(t0, 0, t1, 0, z2_50_0, 0);
        curve25519.square(t1, 0, t0, 0);
        curve25519.square(t0, 0, t1, 0);
        curve25519.square(t1, 0, t0, 0);
        curve25519.square(t0, 0, t1, 0);
        curve25519.square(t1, 0, t0, 0);
        curve25519.mult(outv, outvoffset, t1, 0, z11, 0);
    }

    public static int crypto_scalarmult(byte[] q, byte[] n, byte[] p) {
        int i;
        int[] work = new int[96];
        byte[] e = new byte[32];
        for (i = 0; i < 32; ++i) {
            e[i] = n[i];
        }
        e[0] = (byte)(e[0] & 0xF8);
        e[31] = (byte)(e[31] & 0x7F);
        e[31] = (byte)(e[31] | 0x40);
        for (i = 0; i < 32; ++i) {
            work[i] = p[i] & 0xFF;
        }
        curve25519.mainloop(work, e);
        curve25519.recip(work, 32, work, 32);
        curve25519.mult(work, 64, work, 0, work, 32);
        curve25519.freeze(work, 64);
        for (i = 0; i < 32; ++i) {
            q[i] = (byte)work[64 + i];
        }
        return 0;
    }
}

