// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

use super::tee_api_types::*;
use std::ptr::null;

pub const TEE_INT_CORE_API_SPEC_VERSION: u32 = 0x0000000A;

pub const TEE_HANDLE_NULL: *const u32 = null();

pub const TEE_TIMEOUT_INFINITE: u32 = 0xFFFFFFFF;

// API Error Codes
pub const TEE_SUCCESS: u32 = 0x00000000;
pub const TEE_ERROR_CORRUPT_OBJECT: u32 = 0xF0100001;
pub const TEE_ERROR_CORRUPT_OBJECT_2: u32 = 0xF0100002;
pub const TEE_ERROR_STORAGE_NOT_AVAILABLE: u32 = 0xF0100003;
pub const TEE_ERROR_STORAGE_NOT_AVAILABLE_2: u32 = 0xF0100004;
pub const TEE_ERROR_CIPHERTEXT_INVALID: u32 = 0xF0100006;
pub const TEE_ERROR_GENERIC: u32 = 0xFFFF0000;
pub const TEE_ERROR_ACCESS_DENIED: u32 = 0xFFFF0001;
pub const TEE_ERROR_CANCEL: u32 = 0xFFFF0002;
pub const TEE_ERROR_ACCESS_CONFLICT: u32 = 0xFFFF0003;
pub const TEE_ERROR_EXCESS_DATA: u32 = 0xFFFF0004;
pub const TEE_ERROR_BAD_FORMAT: u32 = 0xFFFF0005;
pub const TEE_ERROR_BAD_PARAMETERS: u32 = 0xFFFF0006;
pub const TEE_ERROR_BAD_STATE: u32 = 0xFFFF0007;
pub const TEE_ERROR_ITEM_NOT_FOUND: u32 = 0xFFFF0008;
pub const TEE_ERROR_NOT_IMPLEMENTED: u32 = 0xFFFF0009;
pub const TEE_ERROR_NOT_SUPPORTED: u32 = 0xFFFF000A;
pub const TEE_ERROR_NO_DATA: u32 = 0xFFFF000B;
pub const TEE_ERROR_OUT_OF_MEMORY: u32 = 0xFFFF000C;
pub const TEE_ERROR_BUSY: u32 = 0xFFFF000D;
pub const TEE_ERROR_COMMUNICATION: u32 = 0xFFFF000E;
pub const TEE_ERROR_SECURITY: u32 = 0xFFFF000F;
pub const TEE_ERROR_SHORT_BUFFER: u32 = 0xFFFF0010;
pub const TEE_ERROR_EXTERNAL_CANCEL: u32 = 0xFFFF0011;
pub const TEE_ERROR_OVERFLOW: u32 = 0xFFFF300F;
pub const TEE_ERROR_TARGET_DEAD: u32 = 0xFFFF3024;
pub const TEE_ERROR_STORAGE_NO_SPACE: u32 = 0xFFFF3041;
pub const TEE_ERROR_MAC_INVALID: u32 = 0xFFFF3071;
pub const TEE_ERROR_SIGNATURE_INVALID: u32 = 0xFFFF3072;
pub const TEE_ERROR_TIME_NOT_SET: u32 = 0xFFFF5000;
pub const TEE_ERROR_TIME_NEEDS_RESET: u32 = 0xFFFF5001;

// Parameter Type Constants
pub const TEE_PARAM_TYPE_NONE: u32 = 0;
pub const TEE_PARAM_TYPE_VALUE_INPUT: u32 = 1;
pub const TEE_PARAM_TYPE_VALUE_OUTPUT: u32 = 2;
pub const TEE_PARAM_TYPE_VALUE_INOUT: u32 = 3;
pub const TEE_PARAM_TYPE_MEMREF_INPUT: u32 = 5;
pub const TEE_PARAM_TYPE_MEMREF_OUTPUT: u32 = 6;
pub const TEE_PARAM_TYPE_MEMREF_INOUT: u32 = 7;

// Login Type Constants
pub const TEE_LOGIN_PUBLIC: u32 = 0x00000000;
pub const TEE_LOGIN_USER: u32 = 0x00000001;
pub const TEE_LOGIN_GROUP: u32 = 0x00000002;
pub const TEE_LOGIN_APPLICATION: u32 = 0x00000004;
pub const TEE_LOGIN_APPLICATION_USER: u32 = 0x00000005;
pub const TEE_LOGIN_APPLICATION_GROUP: u32 = 0x00000006;
pub const TEE_LOGIN_TRUSTED_APP: u32 = 0xF0000000;

// Origin Code Constants
pub const TEE_ORIGIN_API: u32 = 0x00000001;
pub const TEE_ORIGIN_COMMS: u32 = 0x00000002;
pub const TEE_ORIGIN_TEE: u32 = 0x00000003;
pub const TEE_ORIGIN_TRUSTED_APP: u32 = 0x00000004;

// Property Sets pseudo handles
pub const TEE_PROPSET_TEE_IMPLEMENTATION: TEE_PropSetHandle = 0xFFFFFFFD as *mut _;
pub const TEE_PROPSET_CURRENT_CLIENT: TEE_PropSetHandle = 0xFFFFFFFE as *mut _;
pub const TEE_PROPSET_CURRENT_TA: TEE_PropSetHandle = 0xFFFFFFFF as *mut _;

// Memory Access Rights Constants
pub const TEE_MEMORY_ACCESS_READ: u32 = 0x00000001;
pub const TEE_MEMORY_ACCESS_WRITE: u32 = 0x00000002;
pub const TEE_MEMORY_ACCESS_ANY_OWNER: u32 = 0x00000004;

// Memory Management Constant
pub const TEE_MALLOC_FILL_ZERO: u32 = 0x00000000;

// Other constants
pub const TEE_STORAGE_PRIVATE: u32 = 0x00000001;

pub const TEE_DATA_FLAG_ACCESS_READ: u32 = 0x00000001;
pub const TEE_DATA_FLAG_ACCESS_WRITE: u32 = 0x00000002;
pub const TEE_DATA_FLAG_ACCESS_WRITE_META: u32 = 0x00000004;
pub const TEE_DATA_FLAG_SHARE_READ: u32 = 0x00000010;
pub const TEE_DATA_FLAG_SHARE_WRITE: u32 = 0x00000020;
pub const TEE_DATA_FLAG_OVERWRITE: u32 = 0x00000400;
pub const TEE_DATA_MAX_POSITION: u32 = 0xFFFFFFFF;
pub const TEE_OBJECT_ID_MAX_LEN: u32 = 64;
pub const TEE_USAGE_EXTRACTABLE: u32 = 0x00000001;
pub const TEE_USAGE_ENCRYPT: u32 = 0x00000002;
pub const TEE_USAGE_DECRYPT: u32 = 0x00000004;
pub const TEE_USAGE_MAC: u32 = 0x00000008;
pub const TEE_USAGE_SIGN: u32 = 0x00000010;
pub const TEE_USAGE_VERIFY: u32 = 0x00000020;
pub const TEE_USAGE_DERIVE: u32 = 0x00000040;
pub const TEE_HANDLE_FLAG_PERSISTENT: u32 = 0x00010000;
pub const TEE_HANDLE_FLAG_INITIALIZED: u32 = 0x00020000;
pub const TEE_HANDLE_FLAG_KEY_SET: u32 = 0x00040000;
pub const TEE_HANDLE_FLAG_EXPECT_TWO_KEYS: u32 = 0x00080000;
pub const TEE_OPERATION_CIPHER: u32 = 1;
pub const TEE_OPERATION_MAC: u32 = 3;
pub const TEE_OPERATION_AE: u32 = 4;
pub const TEE_OPERATION_DIGEST: u32 = 5;
pub const TEE_OPERATION_ASYMMETRIC_CIPHER: u32 = 6;
pub const TEE_OPERATION_ASYMMETRIC_SIGNATURE: u32 = 7;
pub const TEE_OPERATION_KEY_DERIVATION: u32 = 8;
pub const TEE_OPERATION_STATE_INITIAL: u32 = 0x00000000;
pub const TEE_OPERATION_STATE_ACTIVE: u32 = 0x00000001;

// Algorithm Identifiers
pub const TEE_ALG_AES_ECB_NOPAD: u32 = 0x10000010;
pub const TEE_ALG_AES_CBC_NOPAD: u32 = 0x10000110;
pub const TEE_ALG_AES_CTR: u32 = 0x10000210;
pub const TEE_ALG_AES_CTS: u32 = 0x10000310;
pub const TEE_ALG_AES_XTS: u32 = 0x10000410;
pub const TEE_ALG_AES_CBC_MAC_NOPAD: u32 = 0x30000110;
pub const TEE_ALG_AES_CBC_MAC_PKCS5: u32 = 0x30000510;
pub const TEE_ALG_AES_CMAC: u32 = 0x30000610;
pub const TEE_ALG_AES_CCM: u32 = 0x40000710;
pub const TEE_ALG_AES_GCM: u32 = 0x40000810;
pub const TEE_ALG_DES_ECB_NOPAD: u32 = 0x10000011;
pub const TEE_ALG_DES_CBC_NOPAD: u32 = 0x10000111;
pub const TEE_ALG_DES_CBC_MAC_NOPAD: u32 = 0x30000111;
pub const TEE_ALG_DES_CBC_MAC_PKCS5: u32 = 0x30000511;
pub const TEE_ALG_DES3_ECB_NOPAD: u32 = 0x10000013;
pub const TEE_ALG_DES3_CBC_NOPAD: u32 = 0x10000113;
pub const TEE_ALG_DES3_CBC_MAC_NOPAD: u32 = 0x30000113;
pub const TEE_ALG_DES3_CBC_MAC_PKCS5: u32 = 0x30000513;
pub const TEE_ALG_SM4_ECB_NOPAD: u32 = 0x10000014;
pub const TEE_ALG_SM4_CBC_NOPAD: u32 = 0x10000114;
pub const TEE_ALG_SM4_CTR: u32 = 0x10000214;
pub const TEE_ALG_RSASSA_PKCS1_V1_5_MD5: u32 = 0x70001830;
pub const TEE_ALG_RSASSA_PKCS1_V1_5_SHA1: u32 = 0x70002830;
pub const TEE_ALG_RSASSA_PKCS1_V1_5_SHA224: u32 = 0x70003830;
pub const TEE_ALG_RSASSA_PKCS1_V1_5_SHA256: u32 = 0x70004830;
pub const TEE_ALG_RSASSA_PKCS1_V1_5_SHA384: u32 = 0x70005830;
pub const TEE_ALG_RSASSA_PKCS1_V1_5_SHA512: u32 = 0x70006830;
pub const TEE_ALG_RSASSA_PKCS1_V1_5_MD5SHA1: u32 = 0x7000F830;
pub const TEE_ALG_RSASSA_PKCS1_PSS_MGF1_SHA1: u32 = 0x70212930;
pub const TEE_ALG_RSASSA_PKCS1_PSS_MGF1_SHA224: u32 = 0x70313930;
pub const TEE_ALG_RSASSA_PKCS1_PSS_MGF1_SHA256: u32 = 0x70414930;
pub const TEE_ALG_RSASSA_PKCS1_PSS_MGF1_SHA384: u32 = 0x70515930;
pub const TEE_ALG_RSASSA_PKCS1_PSS_MGF1_SHA512: u32 = 0x70616930;
pub const TEE_ALG_RSAES_PKCS1_V1_5: u32 = 0x60000130;
pub const TEE_ALG_RSAES_PKCS1_OAEP_MGF1_SHA1: u32 = 0x60210230;
pub const TEE_ALG_RSAES_PKCS1_OAEP_MGF1_SHA224: u32 = 0x60310230;
pub const TEE_ALG_RSAES_PKCS1_OAEP_MGF1_SHA256: u32 = 0x60410230;
pub const TEE_ALG_RSAES_PKCS1_OAEP_MGF1_SHA384: u32 = 0x60510230;
pub const TEE_ALG_RSAES_PKCS1_OAEP_MGF1_SHA512: u32 = 0x60610230;
pub const TEE_ALG_RSA_NOPAD: u32 = 0x60000030;
pub const TEE_ALG_DSA_SHA1: u32 = 0x70002131;
pub const TEE_ALG_DSA_SHA224: u32 = 0x70003131;
pub const TEE_ALG_DSA_SHA256: u32 = 0x70004131;
pub const TEE_ALG_SM2_DSA_SM3: u32 = 0x70006045;
pub const TEE_ALG_DH_DERIVE_SHARED_SECRET: u32 = 0x80000032;
pub const TEE_ALG_SM2_KEP: u32 = 0x60000045;
pub const TEE_ALG_MD5: u32 = 0x50000001;
pub const TEE_ALG_SHA1: u32 = 0x50000002;
pub const TEE_ALG_SHA224: u32 = 0x50000003;
pub const TEE_ALG_SHA256: u32 = 0x50000004;
pub const TEE_ALG_SHA384: u32 = 0x50000005;
pub const TEE_ALG_SHA512: u32 = 0x50000006;
pub const TEE_ALG_MD5SHA1: u32 = 0x5000000F;
pub const TEE_ALG_HMAC_MD5: u32 = 0x30000001;
pub const TEE_ALG_HMAC_SHA1: u32 = 0x30000002;
pub const TEE_ALG_HMAC_SHA224: u32 = 0x30000003;
pub const TEE_ALG_HMAC_SHA256: u32 = 0x30000004;
pub const TEE_ALG_HMAC_SHA384: u32 = 0x30000005;
pub const TEE_ALG_HMAC_SHA512: u32 = 0x30000006;
pub const TEE_ALG_HMAC_SM3: u32 = 0x30000007;
pub const TEE_ALG_ECDSA_P192: u32 = 0x70001041;
pub const TEE_ALG_ECDSA_P224: u32 = 0x70002041;
pub const TEE_ALG_ECDSA_P256: u32 = 0x70003041;
pub const TEE_ALG_ECDSA_P384: u32 = 0x70004041;
pub const TEE_ALG_ECDSA_P521: u32 = 0x70005041;
pub const TEE_ALG_ECDH_P192: u32 = 0x80001042;
pub const TEE_ALG_ECDH_P224: u32 = 0x80002042;
pub const TEE_ALG_ECDH_P256: u32 = 0x80003042;
pub const TEE_ALG_ECDH_P384: u32 = 0x80004042;
pub const TEE_ALG_ECDH_P521: u32 = 0x80005042;
pub const TEE_ALG_SM2_PKE: u32 = 0x80000045;
pub const TEE_ALG_SM3: u32 = 0x50000007;
pub const TEE_ALG_ILLEGAL_VALUE: u32 = 0xEFFFFFFF;

// Object Types
pub const TEE_TYPE_AES: u32 = 0xA0000010;
pub const TEE_TYPE_DES: u32 = 0xA0000011;
pub const TEE_TYPE_DES3: u32 = 0xA0000013;
pub const TEE_TYPE_SM4: u32 = 0xA0000014;
pub const TEE_TYPE_HMAC_MD5: u32 = 0xA0000001;
pub const TEE_TYPE_HMAC_SHA1: u32 = 0xA0000002;
pub const TEE_TYPE_HMAC_SHA224: u32 = 0xA0000003;
pub const TEE_TYPE_HMAC_SHA256: u32 = 0xA0000004;
pub const TEE_TYPE_HMAC_SHA384: u32 = 0xA0000005;
pub const TEE_TYPE_HMAC_SHA512: u32 = 0xA0000006;
pub const TEE_TYPE_HMAC_SM3: u32 = 0xA0000007;
pub const TEE_TYPE_RSA_PUBLIC_KEY: u32 = 0xA0000030;
pub const TEE_TYPE_RSA_KEYPAIR: u32 = 0xA1000030;
pub const TEE_TYPE_DSA_PUBLIC_KEY: u32 = 0xA0000031;
pub const TEE_TYPE_DSA_KEYPAIR: u32 = 0xA1000031;
pub const TEE_TYPE_DH_KEYPAIR: u32 = 0xA1000032;
pub const TEE_TYPE_ECDSA_PUBLIC_KEY: u32 = 0xA0000041;
pub const TEE_TYPE_ECDSA_KEYPAIR: u32 = 0xA1000041;
pub const TEE_TYPE_ECDH_PUBLIC_KEY: u32 = 0xA0000042;
pub const TEE_TYPE_ECDH_KEYPAIR: u32 = 0xA1000042;
pub const TEE_TYPE_SM2_DSA_PUBLIC_KEY: u32 = 0xA0000045;
pub const TEE_TYPE_SM2_DSA_KEYPAIR: u32 = 0xA1000045;
pub const TEE_TYPE_SM2_KEP_PUBLIC_KEY: u32 = 0xA0000046;
pub const TEE_TYPE_SM2_KEP_KEYPAIR: u32 = 0xA1000046;
pub const TEE_TYPE_SM2_PKE_PUBLIC_KEY: u32 = 0xA0000047;
pub const TEE_TYPE_SM2_PKE_KEYPAIR: u32 = 0xA1000047;
pub const TEE_TYPE_GENERIC_SECRET: u32 = 0xA0000000;
pub const TEE_TYPE_CORRUPTED_OBJECT: u32 = 0xA00000BE;
pub const TEE_TYPE_DATA: u32 = 0xA00000BF;

// List of Object or Operation Attributes
pub const TEE_ATTR_SECRET_VALUE: u32 = 0xC0000000;
pub const TEE_ATTR_RSA_MODULUS: u32 = 0xD0000130;
pub const TEE_ATTR_RSA_PUBLIC_EXPONENT: u32 = 0xD0000230;
pub const TEE_ATTR_RSA_PRIVATE_EXPONENT: u32 = 0xC0000330;
pub const TEE_ATTR_RSA_PRIME1: u32 = 0xC0000430;
pub const TEE_ATTR_RSA_PRIME2: u32 = 0xC0000530;
pub const TEE_ATTR_RSA_EXPONENT1: u32 = 0xC0000630;
pub const TEE_ATTR_RSA_EXPONENT2: u32 = 0xC0000730;
pub const TEE_ATTR_RSA_COEFFICIENT: u32 = 0xC0000830;
pub const TEE_ATTR_DSA_PRIME: u32 = 0xD0001031;
pub const TEE_ATTR_DSA_SUBPRIME: u32 = 0xD0001131;
pub const TEE_ATTR_DSA_BASE: u32 = 0xD0001231;
pub const TEE_ATTR_DSA_PUBLIC_VALUE: u32 = 0xD0000131;
pub const TEE_ATTR_DSA_PRIVATE_VALUE: u32 = 0xC0000231;
pub const TEE_ATTR_DH_PRIME: u32 = 0xD0001032;
pub const TEE_ATTR_DH_SUBPRIME: u32 = 0xD0001132;
pub const TEE_ATTR_DH_BASE: u32 = 0xD0001232;
pub const TEE_ATTR_DH_X_BITS: u32 = 0xF0001332;
pub const TEE_ATTR_DH_PUBLIC_VALUE: u32 = 0xD0000132;
pub const TEE_ATTR_DH_PRIVATE_VALUE: u32 = 0xC0000232;
pub const TEE_ATTR_RSA_OAEP_LABEL: u32 = 0xD0000930;
pub const TEE_ATTR_RSA_PSS_SALT_LENGTH: u32 = 0xF0000A30;
pub const TEE_ATTR_ECC_PUBLIC_VALUE_X: u32 = 0xD0000141;
pub const TEE_ATTR_ECC_PUBLIC_VALUE_Y: u32 = 0xD0000241;
pub const TEE_ATTR_ECC_PRIVATE_VALUE: u32 = 0xC0000341;
pub const TEE_ATTR_ECC_CURVE: u32 = 0xF0000441;
pub const TEE_ATTR_SM2_ID_INITIATOR: u32 = 0xD0000446;
pub const TEE_ATTR_SM2_ID_RESPONDER: u32 = 0xD0000546;
pub const TEE_ATTR_SM2_KEP_USER: u32 = 0xF0000646;
pub const TEE_ATTR_SM2_KEP_CONFIRMATION_IN: u32 = 0xD0000746;
pub const TEE_ATTR_SM2_KEP_CONFIRMATION_OUT: u32 = 0xD0000846;
pub const TEE_ATTR_ECC_EPHEMERAL_PUBLIC_VALUE_X: u32 = 0xD0000946;
pub const TEE_ATTR_ECC_EPHEMERAL_PUBLIC_VALUE_Y: u32 = 0xD0000A46;
pub const TEE_ATTR_FLAG_PUBLIC: u32 = (1 << 28);
pub const TEE_ATTR_FLAG_VALUE: u32 = (1 << 29);
// Deprecated, but kept for backwards compatibility
pub const TEE_ATTR_BIT_PROTECTED: u32 = (1 << 28);
pub const TEE_ATTR_BIT_VALUE: u32 = (1 << 29);

// List of Supported ECC Curves
pub const TEE_CRYPTO_ELEMENT_NONE: u32 = 0x00000000;
pub const TEE_ECC_CURVE_NIST_P192: u32 = 0x00000001;
pub const TEE_ECC_CURVE_NIST_P224: u32 = 0x00000002;
pub const TEE_ECC_CURVE_NIST_P256: u32 = 0x00000003;
pub const TEE_ECC_CURVE_NIST_P384: u32 = 0x00000004;
pub const TEE_ECC_CURVE_NIST_P521: u32 = 0x00000005;
pub const TEE_ECC_CURVE_SM2: u32 = 0x00000300;

// Panicked Functions Identification
// TA Interface
pub const TEE_PANIC_ID_TA_CLOSESESSIONENTRYPOINT: u32 = 0x00000101;
pub const TEE_PANIC_ID_TA_CREATEENTRYPOINT: u32 = 0x00000102;
pub const TEE_PANIC_ID_TA_DESTROYENTRYPOINT: u32 = 0x00000103;
pub const TEE_PANIC_ID_TA_INVOKECOMMANDENTRYPOINT: u32 = 0x00000104;
pub const TEE_PANIC_ID_TA_OPENSESSIONENTRYPOINT: u32 = 0x00000105;
/* Property Access */
pub const TEE_PANIC_ID_TEE_ALLOCATEPROPERTYENUMERATOR: u32 = 0x00000201;
pub const TEE_PANIC_ID_TEE_FREEPROPERTYENUMERATOR: u32 = 0x00000202;
pub const TEE_PANIC_ID_TEE_GETNEXTPROPERTY: u32 = 0x00000203;
pub const TEE_PANIC_ID_TEE_GETPROPERTYASBINARYBLOCK: u32 = 0x00000204;
pub const TEE_PANIC_ID_TEE_GETPROPERTYASBOOL: u32 = 0x00000205;
pub const TEE_PANIC_ID_TEE_GETPROPERTYASIDENTITY: u32 = 0x00000206;
pub const TEE_PANIC_ID_TEE_GETPROPERTYASSTRING: u32 = 0x00000207;
pub const TEE_PANIC_ID_TEE_GETPROPERTYASU32: u32 = 0x00000208;
pub const TEE_PANIC_ID_TEE_GETPROPERTYASUUID: u32 = 0x00000209;
pub const TEE_PANIC_ID_TEE_GETPROPERTYNAME: u32 = 0x0000020A;
pub const TEE_PANIC_ID_TEE_RESETPROPERTYENUMERATOR: u32 = 0x0000020B;
pub const TEE_PANIC_ID_TEE_STARTPROPERTYENUMERATOR: u32 = 0x0000020C;
// Panic Function
pub const TEE_PANIC_ID_TEE_PANIC: u32 = 0x00000301;
// Internal Client API
pub const TEE_PANIC_ID_TEE_CLOSETASESSION: u32 = 0x00000401;
pub const TEE_PANIC_ID_TEE_INVOKETACOMMAND: u32 = 0x00000402;
pub const TEE_PANIC_ID_TEE_OPENTASESSION: u32 = 0x00000403;
// Cancellation
pub const TEE_PANIC_ID_TEE_GETCANCELLATIONFLAG: u32 = 0x00000501;
pub const TEE_PANIC_ID_TEE_MASKCANCELLATION: u32 = 0x00000502;
pub const TEE_PANIC_ID_TEE_UNMASKCANCELLATION: u32 = 0x00000503;
// Memory Management
pub const TEE_PANIC_ID_TEE_CHECKMEMORYACCESSRIGHTS: u32 = 0x00000601;
pub const TEE_PANIC_ID_TEE_FREE: u32 = 0x00000602;
pub const TEE_PANIC_ID_TEE_GETINSTANCEDATA: u32 = 0x00000603;
pub const TEE_PANIC_ID_TEE_MALLOC: u32 = 0x00000604;
pub const TEE_PANIC_ID_TEE_MEMCOMPARE: u32 = 0x00000605;
pub const TEE_PANIC_ID_TEE_MEMFILL: u32 = 0x00000606;
pub const TEE_PANIC_ID_TEE_MEMMOVE: u32 = 0x00000607;
pub const TEE_PANIC_ID_TEE_REALLOC: u32 = 0x00000608;
pub const TEE_PANIC_ID_TEE_SETINSTANCEDATA: u32 = 0x00000609;
// Generic Object
pub const TEE_PANIC_ID_TEE_CLOSEOBJECT: u32 = 0x00000701;
pub const TEE_PANIC_ID_TEE_GETOBJECTBUFFERATTRIBUTE: u32 = 0x00000702;
// deprecated
pub const TEE_PANIC_ID_TEE_GETOBJECTINFO: u32 = 0x00000703;
pub const TEE_PANIC_ID_TEE_GETOBJECTVALUEATTRIBUTE: u32 = 0x00000704;
// deprecated
pub const TEE_PANIC_ID_TEE_RESTRICTOBJECTUSAGE: u32 = 0x00000705;
pub const TEE_PANIC_ID_TEE_GETOBJECTINFO1: u32 = 0x00000706;
pub const TEE_PANIC_ID_TEE_RESTRICTOBJECTUSAGE1: u32 = 0x00000707;
// Transient Object
pub const TEE_PANIC_ID_TEE_ALLOCATETRANSIENTOBJECT: u32 = 0x00000801;
// deprecated
pub const TEE_PANIC_ID_TEE_COPYOBJECTATTRIBUTES: u32 = 0x00000802;
pub const TEE_PANIC_ID_TEE_FREETRANSIENTOBJECT: u32 = 0x00000803;
pub const TEE_PANIC_ID_TEE_GENERATEKEY: u32 = 0x00000804;
pub const TEE_PANIC_ID_TEE_INITREFATTRIBUTE: u32 = 0x00000805;
pub const TEE_PANIC_ID_TEE_INITVALUEATTRIBUTE: u32 = 0x00000806;
pub const TEE_PANIC_ID_TEE_POPULATETRANSIENTOBJECT: u32 = 0x00000807;
pub const TEE_PANIC_ID_TEE_RESETTRANSIENTOBJECT: u32 = 0x00000808;
pub const TEE_PANIC_ID_TEE_COPYOBJECTATTRIBUTES1: u32 = 0x00000809;
// Persistent Object
// deprecated
pub const TEE_PANIC_ID_TEE_CLOSEANDDELETEPERSISTENTOBJECT: u32 = 0x00000901;
pub const TEE_PANIC_ID_TEE_CREATEPERSISTENTOBJECT: u32 = 0x00000902;
pub const TEE_PANIC_ID_TEE_OPENPERSISTENTOBJECT: u32 = 0x00000903;
pub const TEE_PANIC_ID_TEE_RENAMEPERSISTENTOBJECT: u32 = 0x00000904;
pub const TEE_PANIC_ID_TEE_CLOSEANDDELETEPERSISTENTOBJECT1: u32 = 0x00000905;
// Persistent Object Enumeration
pub const TEE_PANIC_ID_TEE_ALLOCATEPERSISTENTOBJECTENUMERATOR: u32 = 0x00000A01;
pub const TEE_PANIC_ID_TEE_FREEPERSISTENTOBJECTENUMERATOR: u32 = 0x00000A02;
pub const TEE_PANIC_ID_TEE_GETNEXTPERSISTENTOBJECT: u32 = 0x00000A03;
pub const TEE_PANIC_ID_TEE_RESETPERSISTENTOBJECTENUMERATOR: u32 = 0x00000A04;
pub const TEE_PANIC_ID_TEE_STARTPERSISTENTOBJECTENUMERATOR: u32 = 0x00000A05;
// Data Stream Access
pub const TEE_PANIC_ID_TEE_READOBJECTDATA: u32 = 0x00000B01;
pub const TEE_PANIC_ID_TEE_SEEKOBJECTDATA: u32 = 0x00000B02;
pub const TEE_PANIC_ID_TEE_TRUNCATEOBJECTDATA: u32 = 0x00000B03;
pub const TEE_PANIC_ID_TEE_WRITEOBJECTDATA: u32 = 0x00000B04;
// Generic Operation
pub const TEE_PANIC_ID_TEE_ALLOCATEOPERATION: u32 = 0x00000C01;
pub const TEE_PANIC_ID_TEE_COPYOPERATION: u32 = 0x00000C02;
pub const TEE_PANIC_ID_TEE_FREEOPERATION: u32 = 0x00000C03;
pub const TEE_PANIC_ID_TEE_GETOPERATIONINFO: u32 = 0x00000C04;
pub const TEE_PANIC_ID_TEE_RESETOPERATION: u32 = 0x00000C05;
pub const TEE_PANIC_ID_TEE_SETOPERATIONKEY: u32 = 0x00000C06;
pub const TEE_PANIC_ID_TEE_SETOPERATIONKEY2: u32 = 0x00000C07;
pub const TEE_PANIC_ID_TEE_GETOPERATIONINFOMULTIPLE: u32 = 0x00000C08;
// Message Digest
pub const TEE_PANIC_ID_TEE_DIGESTDOFINAL: u32 = 0x00000D01;
pub const TEE_PANIC_ID_TEE_DIGESTUPDATE: u32 = 0x00000D02;
// Symmetric Cipher
pub const TEE_PANIC_ID_TEE_CIPHERDOFINAL: u32 = 0x00000E01;
pub const TEE_PANIC_ID_TEE_CIPHERINIT: u32 = 0x00000E02;
pub const TEE_PANIC_ID_TEE_CIPHERUPDATE: u32 = 0x00000E03;
// MAC
pub const TEE_PANIC_ID_TEE_MACCOMPAREFINAL: u32 = 0x00000F01;
pub const TEE_PANIC_ID_TEE_MACCOMPUTEFINAL: u32 = 0x00000F02;
pub const TEE_PANIC_ID_TEE_MACINIT: u32 = 0x00000F03;
pub const TEE_PANIC_ID_TEE_MACUPDATE: u32 = 0x00000F04;
// Authenticated Encryption
pub const TEE_PANIC_ID_TEE_AEDECRYPTFINAL: u32 = 0x00001001;
pub const TEE_PANIC_ID_TEE_AEENCRYPTFINAL: u32 = 0x00001002;
pub const TEE_PANIC_ID_TEE_AEINIT: u32 = 0x00001003;
pub const TEE_PANIC_ID_TEE_AEUPDATE: u32 = 0x00001004;
pub const TEE_PANIC_ID_TEE_AEUPDATEAAD: u32 = 0x00001005;
// Asymmetric
pub const TEE_PANIC_ID_TEE_ASYMMETRICDECRYPT: u32 = 0x00001101;
pub const TEE_PANIC_ID_TEE_ASYMMETRICENCRYPT: u32 = 0x00001102;
pub const TEE_PANIC_ID_TEE_ASYMMETRICSIGNDIGEST: u32 = 0x00001103;
pub const TEE_PANIC_ID_TEE_ASYMMETRICVERIFYDIGEST: u32 = 0x00001104;
// Key Derivation
pub const TEE_PANIC_ID_TEE_DERIVEKEY: u32 = 0x00001201;
// Random Data Generation
pub const TEE_PANIC_ID_TEE_GENERATERANDOM: u32 = 0x00001301;
// Time
pub const TEE_PANIC_ID_TEE_GETREETIME: u32 = 0x00001401;
pub const TEE_PANIC_ID_TEE_GETSYSTEMTIME: u32 = 0x00001402;
pub const TEE_PANIC_ID_TEE_GETTAPERSISTENTTIME: u32 = 0x00001403;
pub const TEE_PANIC_ID_TEE_SETTAPERSISTENTTIME: u32 = 0x00001404;
pub const TEE_PANIC_ID_TEE_WAIT: u32 = 0x00001405;
// Memory Allocation and Size of Objects
pub const TEE_PANIC_ID_TEE_BIGINTFMMCONTEXTSIZEINU32: u32 = 0x00001501;
pub const TEE_PANIC_ID_TEE_BIGINTFMMSIZEINU32: u32 = 0x00001502;
// Initialization
pub const TEE_PANIC_ID_TEE_BIGINTINIT: u32 = 0x00001601;
pub const TEE_PANIC_ID_TEE_BIGINTINITFMM: u32 = 0x00001602;
pub const TEE_PANIC_ID_TEE_BIGINTINITFMMCONTEXT: u32 = 0x00001603;
// Converter
pub const TEE_PANIC_ID_TEE_BIGINTCONVERTFROMOCTETSTRING: u32 = 0x00001701;
pub const TEE_PANIC_ID_TEE_BIGINTCONVERTFROMS32: u32 = 0x00001702;
pub const TEE_PANIC_ID_TEE_BIGINTCONVERTTOOCTETSTRING: u32 = 0x00001703;
pub const TEE_PANIC_ID_TEE_BIGINTCONVERTTOS32: u32 = 0x00001704;
// Logical Operation
pub const TEE_PANIC_ID_TEE_BIGINTCMP: u32 = 0x00001801;
pub const TEE_PANIC_ID_TEE_BIGINTCMPS32: u32 = 0x00001802;
pub const TEE_PANIC_ID_TEE_BIGINTGETBIT: u32 = 0x00001803;
pub const TEE_PANIC_ID_TEE_BIGINTGETBITCOUNT: u32 = 0x00001804;
pub const TEE_PANIC_ID_TEE_BIGINTSHIFTRIGHT: u32 = 0x00001805;
// Basic Arithmetic
pub const TEE_PANIC_ID_TEE_BIGINTADD: u32 = 0x00001901;
pub const TEE_PANIC_ID_TEE_BIGINTDIV: u32 = 0x00001902;
pub const TEE_PANIC_ID_TEE_BIGINTMUL: u32 = 0x00001903;
pub const TEE_PANIC_ID_TEE_BIGINTNEG: u32 = 0x00001904;
pub const TEE_PANIC_ID_TEE_BIGINTSQUARE: u32 = 0x00001905;
pub const TEE_PANIC_ID_TEE_BIGINTSUB: u32 = 0x00001906;
// Modular Arithmetic
pub const TEE_PANIC_ID_TEE_BIGINTADDMOD: u32 = 0x00001A01;
pub const TEE_PANIC_ID_TEE_BIGINTINVMOD: u32 = 0x00001A02;
pub const TEE_PANIC_ID_TEE_BIGINTMOD: u32 = 0x00001A03;
pub const TEE_PANIC_ID_TEE_BIGINTMULMOD: u32 = 0x00001A04;
pub const TEE_PANIC_ID_TEE_BIGINTSQUAREMOD: u32 = 0x00001A05;
pub const TEE_PANIC_ID_TEE_BIGINTSUBMOD: u32 = 0x00001A06;
// Other Arithmetic
pub const TEE_PANIC_ID_TEE_BIGINTCOMPUTEEXTENDEDGCD: u32 = 0x00001B01;
pub const TEE_PANIC_ID_TEE_BIGINTISPROBABLEPRIME: u32 = 0x00001B02;
pub const TEE_PANIC_ID_TEE_BIGINTRELATIVEPRIME: u32 = 0x00001B03;
// Fast Modular Multiplication
pub const TEE_PANIC_ID_TEE_BIGINTCOMPUTEFMM: u32 = 0x00001C01;
pub const TEE_PANIC_ID_TEE_BIGINTCONVERTFROMFMM: u32 = 0x00001C02;
pub const TEE_PANIC_ID_TEE_BIGINTCONVERTTOFMM: u32 = 0x00001C03;

pub fn TEE_PARAM_TYPES(t0: u32, t1: u32, t2: u32, t3: u32) -> u32 {
    t0 | t1 << 4 | t2 << 8 | t3 << 12
}

pub const TEE_NUM_PARAMS: u32 = 4;
