---
permalink: /community
sidebar: false
---

# Community

Welcome to the Teaclave community. Here are several ways that you can get involved.

## Mailing List

Join us on our mailing list:
- [dev@teaclave.apache.org](https://lists.apache.org/list.html?dev@teaclave.apache.org):
  development related activities (issues, pull requests from GitHub) and
  community discussions

To subscribe, just send an email to `dev-subscribe@teaclave.apache.org`.

## GitHub Issues

You can also ask questions, propose features, and report bugs in Teaclave's
[GitHub issues](https://github.com/apache/incubator-teaclave/issues). Watch the
project on GitHub to receive latest updates.

## Twitter

Follow [@ApacheTeaclave](https://twitter.com/ApacheTeaclave).

## Contributing

Teaclave is open source in [The Apache Way](https://www.apache.org/theapacheway/),
we aim to create a project that is maintained and owned by the community. All
kinds of contributions are welcome. Read this [document](CONTRIBUTING.md) to
learn more about how to contribute. Huge thanks to our [contributors](CONTRIBUTORS.md).

## Reporting a Vulnerability

We take a very active stance in eliminating security problems in Teaclave. We
strongly encourage folks to report such problems to our private mailing list
first ([private@teaclave.apache.org](mailto:private@teaclave.apache.org)),
before disclosing them in a public forum.

## Organizations and Projects

Apache Teaclave (including the platform and SGX SDK) is being used and actively
contributed by developers from many organizations and other open source
projects. This is a community maintained list of organizations and projects
using and contributing to Teaclave in alphabetical order.

### Organizations
  - [Baidu](https://www.baidu.com/)
  - [ByteDance](https://www.bytedance.com/)
  - [Enigma](https://www.enigma.co/)
  - [LayerX](https://layerx.co.jp/)

### Projects
  - [Advanca](https://github.com/advanca/advanca): A privacy-preserving
    general-purpose compute/storage infrastructure for Dapps.
  - [Anonify](https://github.com/LayerXcom/anonify): A blockchain-agnostic
    execution environment with privacy and auditability based on TEE.
  - [Enigma Core](https://github.com/enigmampc/enigma-core): Enigma Core
    library. The domain: Trusted and Untrusted App in Rust.
  - [Crypto.com Chain](https://github.com/crypto-com/chain): Alpha version
    prototype of Crypto.com Chain.
  - [Occlum](https://github.com/occlum/occlum): Occlum is a memory-safe,
    multi-process library OS for Intel SGX.
  - [Phala Network](https://github.com/Phala-Network/phala-blockchain):
    A TEE-Blockchain hybrid architecture implementing Confidential Contract on
    Polkadot.
  - [SafeTrace](https://github.com/enigmampc/SafeTrace): Privacy preserving
    voluntary COVID-19 self-reporting platform for contact tracing.
  - [Secret Network](https://github.com/enigmampc/SecretNetwork): A
    blockchain-based, open-source protocol that lets anyone perform computations
    on encrypted data, bringing privacy to smart contracts and public
    blockchains.
  - [substraTEE](https://github.com/scs/substraTEE): Trusted Off-Chain Compute
    Framework for substrate blockchains.
  - [Veracruz](https://github.com/veracruz-project/veracruz): Veracruz is a
    framework for defining and deploying collaborative, privacy-preserving
    computations amongst a group of mutually mistrusting individuals.
