# The World of Forked crates

We created a "super repo" at [dingelish/sgx-world](https://github.com/dingelish/sgx-world), which includes all the forked repos as git submodules.

We created a "dumb crate" [dumb-all](https://github.com/dingelish/sgx-world/tree/master/dumb-all) to help us maintain the world of forked crates. Each dependency of dumb-all is a valid crate in Rust-SGX ecosystem. The enabled feature set is likely to be the universe of supported feature set. Exceptions exist in a couple of crates, where there are conflict features.

Generally speaking, to use a forked crate, simply use the following statement:

```toml
wasmi = { git = "https://github.com/mesalock-linux/wasmi-sgx" }
```

No need to config the branch in most cases. Only a few of the forked crates use specific branches.

## Tagging

As of today, Oct 23 2019, cargo still has problem on git dependencies. The issue is [cargo #7497](https://github.com/rust-lang/cargo/issues/7497). It leads to a dependency hell if the Cargo.toml looks like:

```toml
foo = { git = "https://github.com/..." }
foo = { git = "https://github.com/...", rev = "deadbeaf" }
foo = { git = "https://github.com/...", tag = "deadbeaf" }
```

These three foos are all valid, but different from each other in compilation. Assume that crate `bar` depends on foo with the first one, and `haa` depends on foo with the second one, then the dependency tree is going to mess up. So this is the reason that almost all forked crates are tagged with `sgx_1.0.9` but the cross references are not using that tag.

One potential fix is a tool to fix Cargo.lock and remove the redundant crates. I've done this successfully by manually dedup Cargo.lock according to the hash value instead of URI. Maybe we can automate this later"

## The World Map

Generated by `cargo deps` on dumb-all.

![world map](https://github.com/dingelish/sgx-world/raw/master/dumb-all/world.png)

## Security audit

We use [`cargo-audit`](https://github.com/RustSec/cargo-audit) to automatically check for known vulnerabilities. And the pipeline has been added to CI which runs nightly. We'll update immediately once we find a security issue by `cargo-audit`. Thanks to @tarcieri for this fantastic tool!
