// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License..

#ifndef _SPINLOCK_H_
#define _SPINLOCK_H_

#include <stdint.h>

typedef volatile uint32_t sgx_spinlock_t;

#define SGX_SPINLOCK_INITIALIZER 0

#if defined(__cplusplus)
extern "C" {
#endif

uint32_t  sgx_spin_lock(sgx_spinlock_t *lock);
uint32_t  sgx_spin_unlock(sgx_spinlock_t *lock);

#if defined(__cplusplus)
}
#endif

#endif /* !_SGX_SPINLOCK_H_ */
