<!--
  ~ Licensed to the Apache Software Foundation (ASF) under one or more
  ~ contributor license agreements.  See the NOTICE file distributed with
  ~ this work for additional information regarding copyright ownership.
  ~ The ASF licenses this file to You under the Apache License, Version 2.0
  ~ (the "License"); you may not use this file except in compliance with
  ~ the License.  You may obtain a copy of the License at
  ~
  ~    http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  ~
  -->

## Distance Calculator

<p align="center"> 
    <img src="icon.png" width="150px;" class="pe-image-documentation"/>
</p>

***

## Description
Calculates the distance between two latitude/longitude pairs in a single event.

***

## Required input
Requires a position of point on the Earth's surface specified by the two geographic coordinates: the longitude and latitude of the point.

***

## Configuration

### First Longitude
This is the first geographic coordinate that specifies the east-west position of a point on the Earth's surface.

### First Latitude
This is the second geographic coordinate that specifies the north-south position of a point on the Earth's surface.

### Second Longitude
This is the second geographic coordinate that specifies the east-west position of a point on the Earth's surface.

### Second Latitude
This is the second geographic coordinate that specifies the north-south position of a point on the Earth's surface.

## Output
{
  'distance': 12.2
}