/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Injectable } from "@angular/core";

@Injectable()
export class ImageClassification {

  private classes: string[];
  public saved: boolean = true;
  private src;

  newImage(src) {
    this.saved = true;
    this.src = src;
    //TODO get class from backend
    this.classes = [];
  }

  addClass(clazz) {
    this.saved = false;
    this.classes.push(clazz);
  }

  getClasses() {
    return this.classes;
  }

  removeClass(clazz) {
    this.saved = false;
    this.classes = this.classes.filter(c => c != clazz);
  }

  save(): boolean {
    //todo: save  in backend
    this.saved = true;
    return true;
  }
}