/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.storage.api;

import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.apache.streampipes.model.client.ontology.Concept;
import org.apache.streampipes.model.client.ontology.Instance;
import org.apache.streampipes.model.client.ontology.Namespace;
import org.apache.streampipes.model.client.ontology.OntologyNode;
import org.apache.streampipes.model.client.ontology.OntologyQuery;
import org.apache.streampipes.model.client.ontology.Property;
import org.apache.streampipes.model.client.ontology.Resource;

import java.util.List;


public interface IBackgroundKnowledgeStorage {

	List<OntologyNode> getClassHierarchy() throws QueryEvaluationException, RepositoryException, MalformedQueryException;
	
	List<OntologyNode> getPropertyHierarchy() throws RepositoryException, MalformedQueryException, QueryEvaluationException;
	
	
	Property getProperty(String typeId) throws QueryEvaluationException, RepositoryException, MalformedQueryException;
	
	Concept getConcept(String conceptId) throws QueryEvaluationException, RepositoryException, MalformedQueryException;
	
	Instance getInstance(String instanceId) throws QueryEvaluationException, RepositoryException, MalformedQueryException;
	
	
	boolean addProperty(Resource resource);
	
	boolean addConcept(Resource resource);
	
	boolean addIndividual(Resource resource);
	
	
	boolean updateProperty(Property property);
	
	boolean updateConcept(Concept concept);
	
	boolean updateInstance(Instance instance);
	
	List<Namespace> getNamespaces() throws RepositoryException;
	
	boolean addNamespace(Namespace namespace);
	
	boolean deleteNamespace(String prefix);
	
	boolean deleteResource(String resourceId);
	
	OntologyQuery getOntologyResult(OntologyQuery query);
	
	boolean initialize();
	
	
}
