/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.streampipes.container.model.consul;

import java.util.List;

public class ConsulServiceRegistrationBody {

    private String ID;
    private String Name;
    private List<String> Tags;
    private String Address;
    private Integer Port;
    private Boolean EnableTagOverride;
    private HealthCheckConfiguration Check;

    public ConsulServiceRegistrationBody() {
    }

    public String getID() {
        return ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getName() {
        return Name;
    }

    public void setName(String name) {
        Name = name;
    }

    public List<String> getTags() {
        return Tags;
    }

    public void setTags(List<String> tags) {
        Tags = tags;
    }

    public String getAddress() {
        return Address;
    }

    public void setAddress(String address) {
        Address = address;
    }

    public Integer getPort() {
        return Port;
    }

    public void setPort(Integer port) {
        Port = port;
    }

    public Boolean getEnableTagOverride() {
        return EnableTagOverride;
    }

    public void setEnableTagOverride(Boolean enableTagOverride) {
        EnableTagOverride = enableTagOverride;
    }

    public HealthCheckConfiguration getCheck() {
        return Check;
    }

    public void setCheck(HealthCheckConfiguration check) {
        Check = check;
    }
}
