/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.connect.adapter.preprocessing.transform.stream;

import io.fogsy.empire.annotations.RdfProperty;
import org.apache.streampipes.vocabulary.StreamPipes;

import java.util.LinkedList;
import java.util.Map;

public class EventRateTransformationRule implements StreamTransformationRule {

    @RdfProperty(StreamPipes.FILTER_TIME_WINDOW)
    private long aggregationTimeWindow;

    //none (Values from last event), max, min, mean, sum (of the values in the time window)
    @RdfProperty(StreamPipes.AGGREGATION_TYPE)
    private String aggregationType;

    private LinkedList<Map<String, Object>> eventStorage = new LinkedList<>();
    private long lastSentToPipelineTimestamp = System.currentTimeMillis();

    public EventRateTransformationRule(long aggregationTimeWindow, String aggregationType) {
        this.aggregationTimeWindow = aggregationTimeWindow;
        this.aggregationType = aggregationType;
    }

    @Override
    public Map<String, Object> transform(Map<String, Object> event) {
        if (!aggregationType.equals("none")) {
            eventStorage.add(event);
        }

        if (System.currentTimeMillis() > lastSentToPipelineTimestamp + aggregationTimeWindow) {
            switch (aggregationType) {
                case "none":
                    lastSentToPipelineTimestamp = System.currentTimeMillis();
                    return event;
//                case "max":
//                case "min":
//                case "mean":
//                case "sum":

            }
        }
        return null;
    }


}
