/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.streampipes.connect.utils;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import org.apache.streampipes.model.connect.adapter.AdapterDescription;
import org.apache.streampipes.model.connect.adapter.GenericAdapterStreamDescription;
import org.apache.streampipes.model.connect.grounding.FormatDescription;
import org.apache.streampipes.model.schema.EventProperty;
import org.apache.streampipes.model.schema.EventPropertyPrimitive;
import org.apache.streampipes.model.schema.EventSchema;
import org.apache.streampipes.model.staticproperty.FreeTextStaticProperty;
import org.apache.streampipes.serializers.json.GsonSerializer;

import java.util.Arrays;

public class TestAdapterSerializer {

  @Test
  public void testGenericAdapterStreamSerialization() {
    GenericAdapterStreamDescription desc = new GenericAdapterStreamDescription();
    FormatDescription formatDescription = new FormatDescription();
    formatDescription.addConfig(new FreeTextStaticProperty("internal-id", "test", "test"));
    desc.setFormatDescription(formatDescription);

    // Add _id field to json, probably there is a cleaner solution
    String serialized = (GsonSerializer.getAdapterGson().toJson(desc));
    serialized = serialized.substring(1);
    serialized = "{\"_id\": \"1\", \"_rev\": \"2\"," + serialized;

    AdapterDescription deserialized = GsonSerializer.getAdapterGson().fromJson(serialized, AdapterDescription.class);
    assertEquals(deserialized.getAdapterId(), "http://streampipes.org/genericadapterstreamdescription");
  }

  @Test
  public void testEventPropertySerialization() {
    EventSchema schema = new EventSchema();
    EventProperty primitive = new EventPropertyPrimitive();
    primitive.setRuntimeName("test");
    ((EventPropertyPrimitive) primitive).setRuntimeType("test");
    schema.setEventProperties(Arrays.asList(primitive));
    String serialized = GsonSerializer.getGson().toJson(primitive);
    System.out.println(serialized);
  }

//  @Test
//  public void testCouchDbSerialization() {
//    GenericAdapterStreamDescription desc = new GenericAdapterStreamDescription();
//
//    new AdapterStorageImpl().storeAdapter(desc);
//
//    AdapterDescription deserialized = new AdapterStorageImpl().getAllAdapters().get(0);
//    System.out.println(deserialized.getAdapterId());
//  }

}
