/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.streampipes.connect.container.worker.rest;

import org.apache.streampipes.connect.container.worker.management.HttpServerAdapterManagement;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path("/api/v1/{username}/worker/live")
public class HttpServerAdapterResource {

  @POST
  @Path("{endpointId}")
  public Response receiveEvent(@PathParam("endpointId") String endpointId,
                               byte[] body) {

    try {
      HttpServerAdapterManagement.INSTANCE.notify(endpointId, body);
      return Response.ok().build();
    } catch (Exception e) {
      return Response.status(400).entity(e.getMessage()).build();
    }

  }
}
