/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.connect.container.master.rest;

import org.apache.streampipes.connect.container.master.management.WorkerAdministrationManagement;
import org.apache.streampipes.connect.rest.AbstractContainerResource;
import org.apache.streampipes.model.connect.worker.ConnectWorkerContainer;
import org.apache.streampipes.model.message.Notifications;
import org.apache.streampipes.rest.shared.annotation.JacksonSerialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("v2/connect/{username}/master/administration")
public class WorkerAdministrationResource extends AbstractContainerResource {

    private Logger LOG = LoggerFactory.getLogger(WorkerAdministrationResource.class);

    private WorkerAdministrationManagement workerAdministrationManagement;

    public WorkerAdministrationResource() {
        this.workerAdministrationManagement = new WorkerAdministrationManagement();
    }

    @POST
    @JacksonSerialized
    @Produces(MediaType.APPLICATION_JSON)
    public Response addWorkerContainer(ConnectWorkerContainer connectWorkerContainer) {
        LOG.info("Worker container: " + connectWorkerContainer.getEndpointUrl() + " was detected");
        this.workerAdministrationManagement.register(connectWorkerContainer);

        return ok(Notifications.success("Worker Container sucessfully added"));
    }

}
