/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.streampipes.client;

public class StreamPipesCredentials {

  private String username;
  private String apiKey;

  /**
   * Create new credentials settings
   * @param username The username of the authenticated user - note that this is currently the email address of the registered user!
   * @param apiKey The API key as generated by StreamPipes
   */
  public static StreamPipesCredentials from(String username, String apiKey) {
    return new StreamPipesCredentials(username, apiKey);
  }

  private StreamPipesCredentials(String username, String apiKey) {
    this.username = username;
    this.apiKey = apiKey;
  }

  public String getUsername() {
    return username;
  }

  public String getApiKey() {
    return apiKey;
  }
}
