/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

import { Component, Input } from '@angular/core';
import { AdapterDescriptionUnion } from '@streampipes/platform-services';
import { DialogRef } from '@streampipes/shared-ui';

@Component({
    selector: 'sp-dialog-adapter-started-dialog',
    templateUrl: './adapter-export-dialog.html',
    styleUrls: ['./adapter-export-dialog.component.scss'],
})
export class AdapterExportDialog {

  @Input()
  adapter: AdapterDescriptionUnion;

    constructor(
        private dialogRef: DialogRef<AdapterExportDialog>) {

    }

    ngOnInit() {
        delete this.adapter['userName'];
    }

    download() {
            const adapterDescriptionAsList = [this.adapter];
            const data = 'data:application/json;charset=utf-8,' + encodeURIComponent(JSON.stringify(adapterDescriptionAsList, null, 2));
            const downloader = document.createElement('a');
            downloader.setAttribute('href', data);
            downloader.setAttribute('download', this.adapter.name + '-adapter-template.json');
            downloader.click();
    }

    onCloseConfirm() {
        this.dialogRef.close();
    }
}
