/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesLeaderElector;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesRunningJobsRegistry
implements RunningJobsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesRunningJobsRegistry.class);
    private final FlinkKubeClient kubeClient;
    private final String configMapName;
    private final String lockIdentity;

    public KubernetesRunningJobsRegistry(FlinkKubeClient kubeClient, String configMapName, String lockIdentity) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.configMapName = (String)Preconditions.checkNotNull((Object)configMapName);
        this.lockIdentity = (String)Preconditions.checkNotNull((Object)lockIdentity);
    }

    public void setJobRunning(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        this.writeJobStatusToConfigMap(jobID, RunningJobsRegistry.JobSchedulingStatus.RUNNING);
    }

    public void setJobFinished(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        this.writeJobStatusToConfigMap(jobID, RunningJobsRegistry.JobSchedulingStatus.DONE);
    }

    public RunningJobsRegistry.JobSchedulingStatus getJobSchedulingStatus(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        return this.kubeClient.getConfigMap(this.configMapName).map(configMap -> this.getJobStatus((KubernetesConfigMap)configMap, jobID).orElse(RunningJobsRegistry.JobSchedulingStatus.PENDING)).orElseThrow(() -> new IOException("ConfigMap " + this.configMapName + " does not exist."));
    }

    public void clearJob(JobID jobID) throws IOException {
        Preconditions.checkNotNull((Object)jobID);
        try {
            this.kubeClient.checkAndUpdateConfigMap(this.configMapName, configMap -> {
                if (KubernetesLeaderElector.hasLeadership(configMap, this.lockIdentity) && configMap.getData().remove(this.getKeyForJobId(jobID)) != null) {
                    return Optional.of(configMap);
                }
                return Optional.empty();
            }).get();
        }
        catch (Exception e) {
            throw new IOException("Failed to clear job state in ConfigMap " + this.configMapName + " for job " + jobID, e);
        }
    }

    private void writeJobStatusToConfigMap(JobID jobID, RunningJobsRegistry.JobSchedulingStatus status) throws IOException {
        LOG.debug("Setting scheduling state for job {} to {}.", (Object)jobID, (Object)status);
        String key = this.getKeyForJobId(jobID);
        try {
            this.kubeClient.checkAndUpdateConfigMap(this.configMapName, configMap -> {
                Optional<RunningJobsRegistry.JobSchedulingStatus> optional;
                if (KubernetesLeaderElector.hasLeadership(configMap, this.lockIdentity) && (!(optional = this.getJobStatus((KubernetesConfigMap)configMap, jobID)).isPresent() || optional.get() != status)) {
                    configMap.getData().put(key, status.name());
                    return Optional.of(configMap);
                }
                return Optional.empty();
            }).get();
        }
        catch (Exception e) {
            throw new IOException("Failed to set " + status.name() + " state in ConfigMap " + this.configMapName + " for job " + jobID, e);
        }
    }

    private Optional<RunningJobsRegistry.JobSchedulingStatus> getJobStatus(KubernetesConfigMap configMap, JobID jobId) {
        String key = this.getKeyForJobId(jobId);
        String status = configMap.getData().get(key);
        if (!StringUtils.isNullOrWhitespaceOnly((String)status)) {
            return Optional.of(RunningJobsRegistry.JobSchedulingStatus.valueOf((String)status));
        }
        return Optional.empty();
    }

    private String getKeyForJobId(JobID jobId) {
        return "runningJobsRegistry-" + jobId.toString();
    }
}

