/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class ReduceApplyWindowFunction<K, W extends Window, T, R>
extends WrappingFunction<WindowFunction<T, R, K, W>>
implements WindowFunction<T, R, K, W> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;

    public ReduceApplyWindowFunction(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> windowFunction) {
        super(windowFunction);
        this.reduceFunction = reduceFunction;
    }

    @Override
    public void apply(K k, W window, Iterable<T> input, Collector<R> out) throws Exception {
        Object curr = null;
        for (T val : input) {
            if (curr == null) {
                curr = val;
                continue;
            }
            curr = this.reduceFunction.reduce(curr, val);
        }
        ((WindowFunction)this.wrappedFunction).apply(k, window, Collections.singletonList(curr), out);
    }
}

