/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.flink.kubernetes.shaded.okhttp3.OkHttpClient;

public class CreateOnlyResourceOperationsImpl<I, O>
extends OperationSupport
implements InOutCreateable<I, O> {
    private final Class<O> outputClassType;

    public CreateOnlyResourceOperationsImpl(OkHttpClient client, Config config, String apiGroupName, String apiGroupVersion, String plural, Class<O> outputClassType) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config), apiGroupName, apiGroupVersion, plural, outputClassType);
    }

    public CreateOnlyResourceOperationsImpl(OperationContext context, String apiGroupName, String apiGroupVersion, String plural, Class<O> outputClassType) {
        super(context.withApiGroupName(apiGroupName).withApiGroupVersion(apiGroupVersion).withPlural(plural));
        this.outputClassType = outputClassType;
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public O create(I ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(resources[0], this.outputClassType);
            }
            return this.handleCreate(this.getItem(), this.outputClassType);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    @Override
    public O create(I item) {
        try {
            return this.handleCreate(item, this.outputClassType);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    public I getItem() {
        return (I)this.context.getItem();
    }
}

