/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.streaming.runtime.operators.sink.CommitterHandler;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

class CommitRetrier {
    private final ProcessingTimeService processingTimeService;
    private final CommitterHandler<?, ?> committerHandler;
    private final Clock clock;
    @VisibleForTesting
    static final int RETRY_DELAY = 1000;

    public CommitRetrier(ProcessingTimeService processingTimeService, CommitterHandler<?, ?> committerHandler) {
        this(processingTimeService, committerHandler, (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    public CommitRetrier(ProcessingTimeService processingTimeService, CommitterHandler<?, ?> committerHandler, Clock clock) {
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.committerHandler = (CommitterHandler)Preconditions.checkNotNull(committerHandler);
        this.clock = clock;
    }

    public void retryWithDelay() {
        this.retryAt(this.clock.absoluteTimeMillis() + 1000L);
    }

    private void retryAt(long timestamp) {
        if (this.committerHandler.needsRetry()) {
            this.processingTimeService.registerTimer(timestamp, ts -> {
                if (this.retry(1L)) {
                    this.retryAt(ts + 1000L);
                }
            });
        }
    }

    public void retryIndefinitely() throws IOException, InterruptedException {
        this.retry(Long.MAX_VALUE);
    }

    @VisibleForTesting
    boolean retry(long tries) throws IOException, InterruptedException {
        for (long i = 0L; i < tries; ++i) {
            if (!this.committerHandler.needsRetry()) {
                return false;
            }
            this.committerHandler.retry();
        }
        return this.committerHandler.needsRetry();
    }
}

