Contributing to Apache StormCrawler
============================

Thank you for your intention to contribute to Apache StormCrawler. As an open-source community, we highly appreciate contributions to our project.

To make the process smooth for the project *committers* (those who review and accept changes) and *contributors* (those who propose new changes via pull requests), there are a few rules to follow.

## Contribution Guidelines

We use GitHub Issues and Pull Requests for tracking contributions. We
expect participants to adhere to the GitHub Community Guidelines (found
at https://help.github.com/articles/github-community-guidelines/ ).

### Get Involved

The Apache StormCrawler project is developed by volunteers and is always looking for new contributors to work on all parts of the project. 
Every contribution is welcome and needed to make it better. A contribution can be anything from a small documentation typo fix to a new component. We especially welcome contributions from first-time users.

#### Mailing Lists

To get started, please first join the Apache StormCrawler mailing lists:

#### dev@stormcrawler.apache.org

This list is for development discussions, patch suggestions, and current issues posted to the issue tracker for the project.

- [Subscribe](dev-subscribe@stormcrawler.apache.org)
- [Unsubscribe](dev-unsubscribe@stormcrawler.apache.org)
- [Archives](https://lists.apache.org/list.html?dev@stormcrawler.apache.org)

#### commits@stormcrawler.apache.org

This list follows changes to the project. This list is not for questions. This list is used by git to post changes to the project. If you have questions about any content here, post them to the stormcrawler-dev list above.

- [Subscribe](commits-subscribe@stormcrawler.apache.org)
- [Unsubscribe](commits-unsubscribe@stormcrawler.apache.org)
- [Archives](https://lists.apache.org/list.html?commits@stormcrawler.apache.org)


#### GitHub Discussions

Feel free to use GitHub Discussions to ask any questions you might have when planning your first contribution.

#### Slack Channel

Another way of contacting Apache StormCrawler committers and PMC members is the #stormcrawler Slack channel. This is a great place to meet and get guidance on contributions.

Further details on using the ASF Slack channels and associated expectations can be found at the related [ASF infra page](https://infra.apache.org/slack.html).

**Note:** The ASF Slack requires an @apache.org email address to join as a full member. Users without an @apache.org email address have to be invited.

### Making a Contribution

- Create a new issue on GitHub. Please describe the problem or improvement in the body of the issue. For larger issues, please first contact the developer mailing list and describe the problem.
- Next, create a pull request in GitHub. 

Bigger contributions can eventually only be accepted when an [ICLA, CCLA or software grant](https://www.apache.org/licenses/contributor-agreements.html) is on file.

Contributors who have a history of successful participation are invited to join the project as a committer from the PPMC.