/*
 * Decompiled with CFR 0.152.
 */
package reactor.queue.spec;

import java.io.IOException;
import net.openhft.chronicle.ChronicleConfig;
import reactor.function.Supplier;
import reactor.queue.IndexedChronicleQueuePersistor;
import reactor.queue.PersistentQueue;
import reactor.queue.encoding.Codec;

public class PersistentQueueSpec<T>
implements Supplier<PersistentQueue<T>> {
    private String basePath = System.getProperty("java.io.tmpdir") + "/persistent-queue";
    private boolean clearOnStart = false;
    private boolean deleteOnExit = false;
    private Codec<T> codec;
    private ChronicleConfig config = ChronicleConfig.DEFAULT.clone();

    public PersistentQueueSpec<T> codec(Codec<T> codec) {
        this.codec = codec;
        return this;
    }

    public PersistentQueueSpec<T> basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public PersistentQueueSpec<T> clearOnStart(boolean clearOnStart) {
        this.clearOnStart = clearOnStart;
        return this;
    }

    public PersistentQueueSpec<T> deleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
        return this;
    }

    public PersistentQueueSpec<T> cacheLineSize(int size) {
        this.config.cacheLineSize(size);
        return this;
    }

    public PersistentQueueSpec<T> dataBlockSize(int size) {
        this.config.dataBlockSize(size);
        return this;
    }

    public PersistentQueueSpec<T> indexFileCapacity(int size) {
        this.config.indexFileCapacity(size);
        return this;
    }

    public PersistentQueueSpec<T> indexFileCapacity(boolean synchronousMode) {
        this.config.synchronousMode(synchronousMode);
        return this;
    }

    public PersistentQueueSpec<T> indexFileExcerpts(int excerpts) {
        this.config.indexFileExcerpts(excerpts);
        return this;
    }

    public PersistentQueueSpec<T> minimiseFootprint(boolean minimiseFootprint) {
        this.config.minimiseFootprint(minimiseFootprint);
        return this;
    }

    @Override
    public PersistentQueue<T> get() {
        try {
            return new PersistentQueue<T>(new IndexedChronicleQueuePersistor<T>(this.basePath, this.codec, this.clearOnStart, this.deleteOnExit, this.config));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

