/*
 * Decompiled with CFR 0.152.
 */
package reactor.queue;

import java.util.AbstractQueue;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.queue.InMemoryQueuePersistor;
import reactor.queue.QueuePersistor;

public class PersistentQueue<T>
extends AbstractQueue<T> {
    private final QueuePersistor<T> persistor;

    public PersistentQueue(@Nullable QueuePersistor<T> persistor) {
        this.persistor = null == persistor ? new InMemoryQueuePersistor() : persistor;
    }

    public void close() {
        this.persistor.close();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.persistor.iterator();
    }

    @Override
    public int size() {
        return (int)this.persistor.size();
    }

    @Override
    public boolean offer(T obj) {
        return null != this.persistor.offer().apply(obj);
    }

    @Override
    public T poll() {
        if (this.size() == 0 || !this.persistor.hasNext()) {
            return null;
        }
        return this.persistor.remove().get();
    }

    @Override
    public T peek() {
        if (this.size() == 0 || !this.persistor.hasNext()) {
            return null;
        }
        Long lastId = this.persistor.lastId();
        return this.persistor.get().apply(lastId);
    }
}

