/*
 * Decompiled with CFR 0.152.
 */
package reactor.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.function.Predicate;
import reactor.function.Supplier;

public abstract class Suppliers {
    private Suppliers() {
    }

    public static <T> Supplier<T> supply(final T obj) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return obj;
            }
        };
    }

    public static <T> Supplier<T> supplyOnce(T obj) {
        return Suppliers.drain(Arrays.asList(obj));
    }

    public static <T> Supplier<T> supplyWhile(final T obj, final Predicate<T> predicate) {
        return new Supplier<T>(){

            @Override
            public T get() {
                if (predicate.test(obj)) {
                    return obj;
                }
                return null;
            }
        };
    }

    public static <T> Supplier<T> roundRobin(final T ... objs) {
        final AtomicInteger count = new AtomicInteger();
        final int len = objs.length;
        return new Supplier<T>(){

            @Override
            public T get() {
                return objs[count.getAndIncrement() % len];
            }
        };
    }

    public static <T> Supplier<T> filter(final Iterable<T> src, final Predicate<T> predicate) {
        return new Supplier<T>(){
            Iterator<T> iter;
            {
                this.iter = src.iterator();
            }

            @Override
            public T get() {
                Object obj;
                if (!this.iter.hasNext()) {
                    return null;
                }
                while (!predicate.test(obj = this.iter.next())) {
                }
                return obj;
            }
        };
    }

    public static <T> Supplier<T> drain(Iterable<T> c) {
        final Iterator<T> iter = c.iterator();
        return new Supplier<T>(){

            @Override
            public T get() {
                return iter.hasNext() ? (Object)iter.next() : null;
            }
        };
    }

    public static <T> Supplier<T> drainAll(Iterable<Iterable<T>> iters) {
        ArrayList<Supplier<T>> ls = new ArrayList<Supplier<T>>();
        for (Iterable<T> iter : iters) {
            ls.add(Suppliers.drain(iter));
        }
        return Suppliers.collect(ls);
    }

    public static <T> Supplier<T> collect(List<Supplier<T>> suppliers) {
        final ListIterator<Supplier<T>> iter = suppliers.listIterator();
        return new Supplier<T>(){

            @Override
            public synchronized T get() {
                if (iter.hasNext()) {
                    Object obj = ((Supplier)iter.next()).get();
                    if (null != obj) {
                        return obj;
                    }
                } else if (iter.hasPrevious()) {
                    while (iter.hasPrevious()) {
                        iter.previous();
                    }
                    return this.get();
                }
                return null;
            }
        };
    }
}

