/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.routing;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.event.Event;
import reactor.event.registry.Registration;
import reactor.event.routing.ConsumerInvoker;
import reactor.event.routing.EventRouter;
import reactor.filter.Filter;
import reactor.function.Consumer;
import reactor.function.support.CancelConsumerException;
import reactor.util.Assert;

public class ConsumerFilteringEventRouter
implements EventRouter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Filter filter;
    private final ConsumerInvoker consumerInvoker;

    public ConsumerFilteringEventRouter(Filter filter, ConsumerInvoker consumerInvoker) {
        Assert.notNull(filter, "filter must not be null");
        Assert.notNull(consumerInvoker, "consumerInvoker must not be null");
        this.filter = filter;
        this.consumerInvoker = consumerInvoker;
    }

    @Override
    public void route(Object key, Event<?> event, List<Registration<? extends Consumer<? extends Event<?>>>> consumers, Consumer<?> completionConsumer, Consumer<Throwable> errorConsumer) {
        if (null != consumers) {
            for (Registration<Consumer<Event<?>>> consumer : this.filter.filter(consumers, key)) {
                try {
                    this.invokeConsumer(key, event, consumer);
                }
                catch (Throwable t) {
                    if (null != event.getErrorConsumer()) {
                        event.consumeError(t);
                        continue;
                    }
                    if (null != errorConsumer) {
                        errorConsumer.accept(t);
                        continue;
                    }
                    this.logger.error("Event routing failed for {}: {}", new Object[]{consumer.getObject(), t.getMessage(), t});
                }
            }
        }
        if (null != completionConsumer) {
            try {
                this.consumerInvoker.invoke(completionConsumer, Void.TYPE, event);
            }
            catch (Exception e) {
                if (null != errorConsumer) {
                    errorConsumer.accept(e);
                }
                this.logger.error("Completion Consumer {} failed: {}", new Object[]{completionConsumer, e.getMessage(), e});
            }
        }
    }

    protected void invokeConsumer(Object key, Event<?> event, Registration<? extends Consumer<? extends Event<?>>> registeredConsumer) throws Exception {
        if (!this.isRegistrationActive(registeredConsumer)) {
            return;
        }
        if (null != registeredConsumer.getSelector().getHeaderResolver()) {
            event.getHeaders().setAll(registeredConsumer.getSelector().getHeaderResolver().resolve(key));
        }
        try {
            this.consumerInvoker.invoke(registeredConsumer.getObject(), Void.TYPE, event);
        }
        catch (CancelConsumerException cancel) {
            registeredConsumer.cancel();
        }
        if (registeredConsumer.isCancelAfterUse()) {
            registeredConsumer.cancel();
        }
    }

    private boolean isRegistrationActive(Registration<?> registration) {
        return !registration.isCancelled() && !registration.isPaused();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ConsumerInvoker getConsumerInvoker() {
        return this.consumerInvoker;
    }
}

