/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.dispatch;

import java.util.List;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.registry.Registration;
import reactor.event.registry.Registry;
import reactor.event.routing.EventRouter;
import reactor.function.Consumer;

public abstract class BaseDispatcher
implements Dispatcher {
    @Override
    public <E extends Event<?>> void dispatch(E event, EventRouter eventRouter, Consumer<E> consumer, Consumer<Throwable> errorConsumer) {
        this.dispatch(null, event, null, errorConsumer, eventRouter, consumer);
    }

    @Override
    public <E extends Event<?>> void dispatch(Object key, E event, Registry<Consumer<? extends Event<?>>> consumerRegistry, Consumer<Throwable> errorConsumer, EventRouter eventRouter, Consumer<E> completionConsumer) {
        if (!this.alive()) {
            throw new IllegalStateException("This Dispatcher has been shutdown");
        }
        Task<E> task = this.createTask();
        task.setKey(key);
        task.setEvent(event);
        task.setConsumerRegistry(consumerRegistry);
        task.setErrorConsumer(errorConsumer);
        task.setEventRouter(eventRouter);
        task.setCompletionConsumer(completionConsumer);
        task.submit();
    }

    protected abstract <E extends Event<?>> Task<E> createTask();

    protected abstract class Task<E extends Event<?>> {
        private volatile Object key;
        private volatile Registry<Consumer<? extends Event<?>>> consumerRegistry;
        private volatile E event;
        private volatile Consumer<E> completionConsumer;
        private volatile Consumer<Throwable> errorConsumer;
        private volatile EventRouter eventRouter;

        protected Task() {
        }

        Task<E> setKey(Object key) {
            this.key = key;
            return this;
        }

        Task<E> setConsumerRegistry(Registry<Consumer<? extends Event<?>>> consumerRegistry) {
            this.consumerRegistry = consumerRegistry;
            return this;
        }

        Task<E> setEvent(E event) {
            this.event = event;
            return this;
        }

        Task<E> setCompletionConsumer(Consumer<E> completionConsumer) {
            this.completionConsumer = completionConsumer;
            return this;
        }

        Task<E> setErrorConsumer(Consumer<Throwable> errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }

        Task<E> setEventRouter(EventRouter eventRouter) {
            this.eventRouter = eventRouter;
            return this;
        }

        protected void reset() {
            this.key = null;
            this.consumerRegistry = null;
            this.event = null;
            this.completionConsumer = null;
            this.errorConsumer = null;
        }

        protected abstract void submit();

        protected void execute() {
            this.eventRouter.route(this.key, (Event<?>)this.event, (List<Registration<? extends Consumer<? extends Event<?>>>>)(null != this.consumerRegistry ? this.consumerRegistry.select(this.key) : null), this.completionConsumer, this.errorConsumer);
        }
    }
}

