/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.spec.support;

import java.util.List;
import reactor.convert.Converter;
import reactor.convert.DelegatingConverter;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.spec.support.DispatcherComponentSpec;
import reactor.event.dispatch.Dispatcher;
import reactor.event.dispatch.TraceableDelegatingDispatcher;
import reactor.event.routing.ArgumentConvertingConsumerInvoker;
import reactor.event.routing.ConsumerFilteringEventRouter;
import reactor.event.routing.ConsumerInvoker;
import reactor.event.routing.EventRouter;
import reactor.event.routing.TraceableDelegatingEventRouter;
import reactor.filter.AbstractFilter;
import reactor.filter.Filter;
import reactor.filter.FirstFilter;
import reactor.filter.PassThroughFilter;
import reactor.filter.RandomFilter;
import reactor.filter.RoundRobinFilter;
import reactor.filter.TraceableDelegatingFilter;
import reactor.util.Assert;

public abstract class EventRoutingComponentSpec<SPEC extends EventRoutingComponentSpec<SPEC, TARGET>, TARGET>
extends DispatcherComponentSpec<SPEC, TARGET> {
    private Converter converter;
    private EventRoutingStrategy eventRoutingStrategy;
    private EventRouter eventRouter;
    private ConsumerInvoker consumerInvoker;
    private Filter eventFilter;
    private boolean traceEventPath = false;

    public final SPEC converters(Converter ... converters) {
        this.converter = new DelegatingConverter(converters);
        return (SPEC)this;
    }

    public final SPEC converters(List<Converter> converters) {
        this.converter = new DelegatingConverter(converters);
        return (SPEC)this;
    }

    public final SPEC eventFilter(Filter filter) {
        Assert.isNull(this.eventRouter, "Cannot set both a filter and a router. Use one or the other.");
        this.eventFilter = filter;
        return (SPEC)this;
    }

    public final SPEC consumerInvoker(ConsumerInvoker consumerInvoker) {
        Assert.isNull(this.eventRouter, "Cannot set both a consumerInvoker and a router. Use one or the other.");
        this.consumerInvoker = consumerInvoker;
        return (SPEC)this;
    }

    public final SPEC eventRouter(EventRouter router) {
        Assert.isNull(this.eventFilter, "Cannot set both a filter and a router. Use one or the other.");
        Assert.isNull(this.consumerInvoker, "Cannot set both a consumerInvoker and a router. Use one or the other.");
        this.eventRouter = router;
        return (SPEC)this;
    }

    public final SPEC broadcastEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.BROADCAST;
        return (SPEC)this;
    }

    public final SPEC randomEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.RANDOM;
        return (SPEC)this;
    }

    public final SPEC firstEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.FIRST;
        return (SPEC)this;
    }

    public final SPEC roundRobinEventRouting() {
        this.eventRoutingStrategy = EventRoutingStrategy.ROUND_ROBIN;
        return (SPEC)this;
    }

    public final SPEC traceEventPath() {
        return this.traceEventPath(true);
    }

    public final SPEC traceEventPath(boolean b) {
        this.traceEventPath = b;
        return (SPEC)this;
    }

    protected abstract TARGET configure(Reactor var1, Environment var2);

    @Override
    protected final TARGET configure(Dispatcher dispatcher, Environment environment) {
        return this.configure(this.createReactor(dispatcher), environment);
    }

    private Reactor createReactor(Dispatcher dispatcher) {
        if (this.traceEventPath) {
            dispatcher = new TraceableDelegatingDispatcher(dispatcher);
        }
        return new Reactor(dispatcher, this.eventRouter != null ? this.eventRouter : this.createEventRouter());
    }

    private EventRouter createEventRouter() {
        ConsumerFilteringEventRouter evr = new ConsumerFilteringEventRouter(this.eventFilter != null ? this.eventFilter : this.createFilter(), this.consumerInvoker != null ? this.consumerInvoker : new ArgumentConvertingConsumerInvoker(this.converter));
        if (this.traceEventPath) {
            return new TraceableDelegatingEventRouter(evr);
        }
        return evr;
    }

    private Filter createFilter() {
        AbstractFilter filter = EventRoutingStrategy.ROUND_ROBIN == this.eventRoutingStrategy ? new RoundRobinFilter() : (EventRoutingStrategy.RANDOM == this.eventRoutingStrategy ? new RandomFilter() : (EventRoutingStrategy.FIRST == this.eventRoutingStrategy ? new FirstFilter() : new PassThroughFilter()));
        return this.traceEventPath ? new TraceableDelegatingFilter(filter) : filter;
    }

    protected static enum EventRoutingStrategy {
        BROADCAST,
        RANDOM,
        ROUND_ROBIN,
        FIRST;

    }
}

