/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.composable.spec;

import reactor.core.Environment;
import reactor.core.composable.Composable;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.DeferredStreamSpec;
import reactor.core.spec.support.DispatcherComponentSpec;
import reactor.event.dispatch.Dispatcher;

public final class StreamSpec<T>
extends DispatcherComponentSpec<StreamSpec<T>, Stream<T>> {
    private Composable<?> parent;
    private int batchSize = -1;
    private Iterable<T> values;

    public StreamSpec<T> link(Composable<?> parent) {
        this.parent = parent;
        return this;
    }

    public StreamSpec<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public StreamSpec<T> each(Iterable<T> values) {
        this.values = values;
        return this;
    }

    @Override
    protected Stream<T> configure(Dispatcher dispatcher, Environment env) {
        if (this.values == null) {
            throw new IllegalStateException("A bounded stream must be configured with some values. Use " + DeferredStreamSpec.class.getSimpleName() + " to create a stream with no initial values");
        }
        return new Stream<T>(dispatcher, this.batchSize, this.values, this.parent);
    }
}

