/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.composable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Observable;
import reactor.core.composable.Composable;
import reactor.core.composable.Deferred;
import reactor.core.spec.Reactors;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.dispatch.SynchronousDispatcher;
import reactor.event.selector.Selector;
import reactor.event.selector.Selectors;
import reactor.event.support.EventConsumer;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.function.Predicate;
import reactor.function.Supplier;
import reactor.tuple.Tuple2;
import reactor.util.Assert;

public class Promise<T>
extends Composable<T>
implements Supplier<T> {
    private final Tuple2<Selector, Object> complete = Selectors.$();
    private final long defaultTimeout;
    private final Environment environment;
    private final Condition pendingCondition;
    private State state = State.PENDING;
    private T value;
    private Throwable error;
    private Supplier<T> supplier;
    private boolean hasBlockers = false;

    public Promise(@Nonnull Dispatcher dispatcher, @Nullable Environment env, @Nullable Composable<?> parent) {
        super(dispatcher, parent);
        this.defaultTimeout = env != null ? env.getProperty("reactor.await.defaultTimeout", Long.class, 30000L) : 30000L;
        this.environment = env;
        this.pendingCondition = this.lock.newCondition();
    }

    public Promise(T value, @Nonnull Dispatcher dispatcher, @Nullable Environment env) {
        this(dispatcher, env, null);
        this.value = value;
        this.state = State.SUCCESS;
    }

    public Promise(Supplier<T> valueSupplier, @Nonnull Dispatcher dispatcher, @Nullable Environment env) {
        this(dispatcher, env, null);
        this.supplier = valueSupplier;
    }

    public Promise(Throwable error, @Nonnull Dispatcher dispatcher, @Nullable Environment env) {
        this(dispatcher, env, null);
        this.error = error;
        this.state = State.FAILURE;
    }

    private void init() {
        this.getObservable().on((Selector)this.getFlush().getT1(), new Consumer<Event<Void>>(){

            @Override
            public void accept(Event<Void> ev) {
                if (null != Promise.this.supplier) {
                    try {
                        Promise.this.notifyValue(Promise.this.supplier.get());
                    }
                    catch (Throwable t) {
                        Promise.this.notifyError(t);
                    }
                }
            }
        });
    }

    public Promise<T> onComplete(@Nonnull Consumer<Promise<T>> onComplete) {
        if (this.isComplete()) {
            Reactors.schedule(onComplete, this, this.getObservable());
        } else {
            this.getObservable().on((Selector)this.complete.getT1(), new EventConsumer<Promise<T>>(onComplete));
        }
        return this;
    }

    public Promise<T> onSuccess(@Nonnull Consumer<T> onSuccess) {
        return this.consume((Consumer)onSuccess);
    }

    public Promise<T> onError(@Nullable Consumer<Throwable> onError) {
        if (null != onError) {
            return this.when(Throwable.class, onError);
        }
        return this;
    }

    public Promise<T> then(@Nonnull Consumer<T> onSuccess, @Nullable Consumer<Throwable> onError) {
        this.onSuccess(onSuccess);
        this.onError(onError);
        return this;
    }

    public <V> Promise<V> then(final @Nonnull Function<T, V> onSuccess, @Nullable Consumer<Throwable> onError) {
        final Deferred d = this.createDeferred();
        Promise<T> p = ((Promise)d.compose()).onError(onError);
        this.onSuccess(new Consumer<T>(){

            @Override
            public void accept(T value) {
                try {
                    d.accept(onSuccess.apply(value));
                }
                catch (Throwable throwable) {
                    d.accept(throwable);
                }
            }
        });
        this.onError(new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                d.accept(t);
            }
        });
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        this.lock.lock();
        try {
            boolean bl = this.state != State.PENDING;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPending() {
        this.lock.lock();
        try {
            boolean bl = this.state == State.PENDING;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuccess() {
        this.lock.lock();
        try {
            boolean bl = this.state == State.SUCCESS;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isError() {
        this.lock.lock();
        try {
            boolean bl = this.state == State.FAILURE;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T await() throws InterruptedException {
        return this.await(this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isPending()) {
            this.flush();
        }
        if (!this.isPending()) {
            return this.get();
        }
        this.lock.lock();
        try {
            this.hasBlockers = true;
            if (timeout >= 0L) {
                long msTimeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
                long endTime = System.currentTimeMillis() + msTimeout;
                while (this.state == State.PENDING && System.currentTimeMillis() < endTime) {
                    this.pendingCondition.await(200L, TimeUnit.MILLISECONDS);
                }
            } else {
                while (this.state == State.PENDING) {
                    this.pendingCondition.await(200L, TimeUnit.MILLISECONDS);
                }
            }
        }
        finally {
            this.hasBlockers = false;
            this.lock.unlock();
        }
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.isPending()) {
            this.flush();
        }
        this.lock.lock();
        try {
            if (this.state == State.SUCCESS) {
                T t = this.value;
                return t;
            }
            if (this.state == State.FAILURE) {
                if (RuntimeException.class.isInstance(this.error)) {
                    throw (RuntimeException)this.error;
                }
                throw new RuntimeException(this.error);
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable reason() {
        this.lock.lock();
        try {
            Throwable throwable = this.error;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> consume(@Nonnull Consumer<T> consumer) {
        this.lock.lock();
        try {
            if (this.state == State.SUCCESS) {
                Reactors.schedule(consumer, this.value, this.getObservable());
            } else {
                super.consume(consumer);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> consume(final @Nonnull Composable<T> composable) {
        this.lock.lock();
        try {
            if (this.state == State.SUCCESS) {
                Reactors.schedule(new Consumer<T>(){

                    @Override
                    public void accept(T t) {
                        composable.notifyValue(t);
                    }
                }, this.value, this.getObservable());
            } else {
                super.consume(composable);
            }
            Promise promise = this;
            return promise;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> consume(@Nonnull Object key, @Nonnull Observable observable) {
        this.lock.lock();
        try {
            if (this.state == State.SUCCESS) {
                observable.notify(key, Event.wrap(this.value));
            } else {
                super.consume(key, observable);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Throwable> Promise<T> when(@Nonnull Class<E> exceptionType, @Nonnull Consumer<E> onError) {
        this.lock.lock();
        try {
            if (this.state == State.FAILURE && exceptionType.isAssignableFrom(this.error.getClass())) {
                Reactors.schedule(onError, this.error, this.getObservable());
            } else {
                super.when(exceptionType, onError);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> Promise<V> map(final @Nonnull Function<T, V> fn) {
        if (this.isPending()) {
            return (Promise)super.map(fn);
        }
        final Deferred d = this.createDeferred();
        this.lock.lock();
        try {
            if (this.state == State.SUCCESS) {
                Reactors.schedule(new Consumer<Void>(){

                    @Override
                    public void accept(Void aVoid) {
                        try {
                            d.accept(fn.apply(Promise.this.value));
                        }
                        catch (Throwable throwable) {
                            d.accept(throwable);
                        }
                    }
                }, null, this.getObservable());
            } else if (this.state == State.FAILURE) {
                d.accept(this.error);
            }
            Promise promise = (Promise)d.compose();
            return promise;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> filter(final @Nonnull Predicate<T> p) {
        if (this.isPending()) {
            return (Promise)super.filter(p);
        }
        final Deferred d = this.createDeferred();
        this.lock.lock();
        try {
            if (this.state == State.SUCCESS) {
                Reactors.schedule(new Consumer<Void>(){

                    @Override
                    public void accept(Void aVoid) {
                        try {
                            if (p.test(Promise.this.value)) {
                                d.accept(Promise.this.value);
                            }
                        }
                        catch (Throwable throwable) {
                            d.accept(throwable);
                        }
                    }
                }, null, this.getObservable());
            } else if (this.state == State.FAILURE) {
                d.accept(this.error);
            }
            Promise promise = (Promise)d.compose();
            return promise;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Promise<T> flush() {
        return (Promise)super.flush();
    }

    @Override
    protected <V, C extends Composable<V>> Deferred<V, C> createDeferred() {
        return new Deferred(new Promise<T>(new SynchronousDispatcher(), this.environment, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void errorAccepted(Throwable error) {
        this.lock.lock();
        try {
            this.assertPending();
            this.error = error;
            this.state = State.FAILURE;
            if (this.hasBlockers) {
                this.pendingCondition.signalAll();
                this.hasBlockers = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.getObservable().notify(this.complete.getT2(), Event.wrap(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void valueAccepted(T value) {
        this.lock.lock();
        try {
            this.assertPending();
            this.value = value;
            this.state = State.SUCCESS;
            if (this.hasBlockers) {
                this.pendingCondition.signalAll();
                this.hasBlockers = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.getObservable().notify(this.complete.getT2(), Event.wrap(this));
    }

    private void assertPending() {
        Assert.state(this.isPending(), "Promise has already completed. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = "Promise{value=" + this.value + ", error=" + this.error + '}';
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum State {
        PENDING,
        SUCCESS,
        FAILURE;

    }
}

