/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.composable;

import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Observable;
import reactor.core.Reactor;
import reactor.core.composable.Deferred;
import reactor.core.support.NotifyConsumer;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.selector.Selector;
import reactor.event.selector.Selectors;
import reactor.event.support.EventConsumer;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.function.Predicate;
import reactor.tuple.Tuple2;
import reactor.util.Assert;

public abstract class Composable<T> {
    protected final ReentrantLock lock = new ReentrantLock();
    private final Tuple2<Selector, Object> accept = Selectors.$();
    private final Tuple2<Selector, Object> flush = Selectors.$();
    private final Observable events;
    private final Composable<?> parent;
    private long acceptCount = 0L;
    private long errorCount = 0L;

    protected <U> Composable(@Nonnull Dispatcher dispatcher, @Nullable Composable<U> parent) {
        Assert.notNull(dispatcher, "'dispatcher' cannot be null.");
        this.events = new Reactor(dispatcher);
        this.parent = parent;
        if (parent != null) {
            parent.cascadeErrors(this);
        }
    }

    public Composable<T> consume(final @Nonnull Composable<T> composable) {
        if (composable == this) {
            throw new IllegalArgumentException("Trying to consume itself, leading to erroneous recursive calls");
        }
        this.consumeEvent(new Consumer<Event<T>>(){

            @Override
            public void accept(Event<T> event) {
                composable.notifyValue(event);
            }
        });
        this.cascadeErrors(composable);
        return this;
    }

    public Composable<T> consume(@Nonnull Consumer<T> consumer) {
        this.events.on((Selector)this.accept.getT1(), new EventConsumer<T>(consumer));
        return this;
    }

    public Composable<T> consumeEvent(@Nonnull Consumer<Event<T>> consumer) {
        this.events.on((Selector)this.accept.getT1(), consumer);
        return this;
    }

    public Composable<T> consume(@Nonnull Object key, @Nonnull Observable observable) {
        this.consume(new NotifyConsumer(key, observable));
        return this;
    }

    public <E extends Throwable> Composable<T> when(@Nonnull Class<E> exceptionType, @Nonnull Consumer<E> onError) {
        this.events.on(Selectors.T(exceptionType), new EventConsumer<E>(onError));
        return this;
    }

    public <V> Composable<V> map(final @Nonnull Function<T, V> fn) {
        Assert.notNull(fn, "Map function cannot be null.");
        final Deferred d = this.createDeferred();
        this.consumeEvent(new Consumer<Event<T>>(){

            @Override
            public void accept(Event<T> value) {
                try {
                    Object val = fn.apply(value.getData());
                    d.acceptEvent(value.copy(val));
                }
                catch (Throwable e) {
                    d.accept(e);
                }
            }
        });
        return d.compose();
    }

    public Composable<T> filter(final @Nonnull Function<T, Boolean> fn) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return (Boolean)fn.apply(t);
            }
        }, null);
    }

    public Composable<T> filter(@Nonnull Predicate<T> p) {
        return this.filter(p, null);
    }

    public Composable<T> filter(final @Nonnull Predicate<T> p, final Composable<T> elseComposable) {
        final Deferred d = this.createDeferred();
        this.consumeEvent(new Consumer<Event<T>>(){

            @Override
            public void accept(Event<T> value) {
                boolean b = p.test(value.getData());
                if (b) {
                    d.acceptEvent(value);
                } else if (null != elseComposable) {
                    elseComposable.notifyValue(value);
                }
            }
        });
        return d.compose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAcceptCount() {
        this.lock.lock();
        try {
            long l = this.acceptCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getErrorCount() {
        this.lock.lock();
        try {
            long l = this.errorCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Composable<T> flush() {
        if (null != this.parent) {
            this.parent.flush();
        }
        this.events.notify(this.flush.getT2(), new Event<Object>(null));
        return this;
    }

    void notifyValue(T value) {
        this.notifyValue(Event.wrap(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyValue(Event<T> value) {
        this.lock.lock();
        try {
            this.valueAccepted(value.getData());
            ++this.acceptCount;
        }
        finally {
            this.lock.unlock();
        }
        this.events.notify(this.accept.getT2(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyError(Throwable error) {
        this.lock.lock();
        try {
            this.errorAccepted(error);
            ++this.errorCount;
        }
        finally {
            this.lock.unlock();
        }
        this.events.notify((Object)error.getClass(), Event.wrap(error));
    }

    protected abstract <V, C extends Composable<V>> Deferred<V, C> createDeferred();

    protected abstract void errorAccepted(Throwable var1);

    protected abstract void valueAccepted(T var1);

    protected void cascadeErrors(final Composable<?> composable) {
        this.when(Throwable.class, new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                composable.notifyError(t);
            }
        });
    }

    protected Observable getObservable() {
        return this.events;
    }

    protected Tuple2<Selector, Object> getAccept() {
        return this.accept;
    }

    protected Composable<?> getParent() {
        return this.parent;
    }

    protected Tuple2<Selector, Object> getFlush() {
        return this.flush;
    }
}

