/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.timer;

import org.apache.shenyu.common.timer.HierarchicalWheelTimer;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;

public class WheelTimerFactory {
    private static final String NAME = "shared_wheel_timer";
    private static final TimerSharedRef SHARED_TIMER = new TimerSharedRef();

    public static Timer getSharedTimer() {
        return (Timer)SHARED_TIMER.getRef();
    }

    public static Timer newWheelTimer() {
        return new HierarchicalWheelTimer(NAME);
    }

    private static class TimerSharedRef
    extends SharedRef<Timer> {
        private TimerSharedRef() {
        }

        @Override
        protected Shared<Timer> create() {
            return new TimerShared(WheelTimerFactory.newWheelTimer());
        }
    }

    private static class TimerShared
    extends Shared<Timer>
    implements Timer {
        TimerShared(Timer shared) {
            super(shared);
        }

        @Override
        protected Timer current() {
            return this;
        }

        @Override
        public void add(TimerTask timerTask) {
            ((Timer)this.getSharedObj()).add(timerTask);
        }

        @Override
        public void advanceClock(long timeoutMs) throws InterruptedException {
            ((Timer)this.getSharedObj()).advanceClock(timeoutMs);
        }

        @Override
        public int size() {
            return ((Timer)this.getSharedObj()).size();
        }

        @Override
        public void shutdown() {
            ((Timer)this.getSharedObj()).shutdown();
        }
    }

    private static abstract class SharedRef<T> {
        private Shared<T> shared;

        private SharedRef() {
        }

        public synchronized T getRef() {
            if (this.shared == null) {
                this.shared = this.create();
            }
            return this.shared.getRef();
        }

        protected abstract Shared<T> create();
    }

    private static abstract class Shared<T> {
        private final T shared;

        Shared(T shared) {
            this.shared = shared;
        }

        public T getRef() {
            return this.current();
        }

        protected T getSharedObj() {
            return this.shared;
        }

        protected abstract T current();
    }
}

