/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.spring;

import com.alibaba.nacos.common.utils.CollectionUtils;
import java.security.SecureRandom;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.AdminResourceEnum;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ResourcePermissionDataSourceLoader
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePermissionDataSourceLoader.class);
    private static final List<String> ICONS = Arrays.asList("border-bottom", "stop", "redo", "highlight", "database", "pause", "align-left", "camera", "pic-center", "pic-left", "retweet", "fire", "block", "thunderbolt", "safety", "key");
    private static final Integer ROUTE = 0;
    private static final Integer STATUS = 1;
    private final Random rand = new SecureRandom();
    private final PluginService pluginService;
    private final ResourceService resourceService;
    private final ShenyuDictService shenyuDictService;

    public ResourcePermissionDataSourceLoader(PluginService pluginService, ResourceService resourceService, ShenyuDictService shenyuDictService) {
        this.pluginService = pluginService;
        this.resourceService = resourceService;
        this.shenyuDictService = shenyuDictService;
    }

    @Transactional(rollbackFor={Exception.class})
    public void run(ApplicationArguments args) throws Exception {
        List<PluginData> pluginDataList;
        ShenyuDictVO shenyuInitData = this.shenyuDictService.findByDictCodeName("INIT_FLAG", "status");
        String id = null;
        if (Objects.nonNull(shenyuInitData)) {
            if (Boolean.TRUE.toString().equals(shenyuInitData.getDictValue())) {
                return;
            }
            id = shenyuInitData.getId();
        }
        if (CollectionUtils.isEmpty(pluginDataList = this.pluginService.listAllNotInResource())) {
            LOG.info("All plugin are permissioned.");
            return;
        }
        List<String> pluginNameList = pluginDataList.stream().filter(Objects::nonNull).map(PluginData::getName).collect(Collectors.toList());
        this.insertResourceBatch(pluginNameList);
        this.resetTableDictStatus(id);
    }

    private void insertResourceBatch(List<String> pluginNameList) {
        if (CollectionUtils.isEmpty(pluginNameList)) {
            return;
        }
        List<ResourceDO> resourceList = pluginNameList.stream().filter(StringUtils::isNotEmpty).map(pluginName -> ResourceDTO.builder().parentId("1346775491550474240").id(UUIDUtils.getInstance().generateShortUuid()).title((String)pluginName).name((String)pluginName).url("/plug/" + pluginName).component((String)pluginName).resourceType(AdminResourceEnum.SECOND_MENU.getCode()).sort(0).icon(ICONS.get(this.rand.nextInt(ICONS.size()))).isLeaf(false).isRoute(ROUTE).perms("").status(STATUS).build()).map(ResourceDO::buildResourceDO).collect(Collectors.toList());
        this.resourceService.createResourceBatch(resourceList);
        List<ResourceDO> resourceChildren = resourceList.stream().filter(resourceDO -> Objects.nonNull(resourceDO) && StringUtils.isNotEmpty((CharSequence)resourceDO.getId())).map(resourceDO -> this.prepareChildrenResource(resourceDO.getId(), resourceDO.getTitle())).flatMap(Collection::stream).collect(Collectors.toList());
        this.resourceService.createResourceBatch(resourceChildren);
    }

    private List<ResourceDO> prepareChildrenResource(String parentId, String pluginName) {
        return Stream.of(new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.SELECTOR.ADD", "Selector:add"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.SELECTOR.QUERY", "Selector:query"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.SELECTOR.EDIT", "Selector:edit"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.SELECTOR.DELETE", "Selector:delete"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.RULE.ADD", "Rule:add"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.RULE.QUERY", "Rule:query"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.RULE.EDIT", "Rule:edit"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.RULE.DELETE", "Rule:delete"), new AbstractMap.SimpleEntry<String, String>("SHENYU.BUTTON.PLUGIN.SYNCHRONIZE", ":modify")).map(simpleEntry -> ResourceDO.buildResourceDO(ResourceDTO.builder().parentId(parentId).name("").title((String)simpleEntry.getKey()).url("").component("").resourceType(AdminResourceEnum.THREE_MENU.getCode()).sort(0).icon("").isLeaf(true).isRoute(ROUTE).perms("plugin:" + pluginName + (String)simpleEntry.getValue()).status(STATUS).build())).collect(Collectors.toList());
    }

    private void resetTableDictStatus(String id) {
        this.shenyuDictService.createOrUpdate(new ShenyuDictDTO(id, "table", "INIT_FLAG", "status", Boolean.TRUE.toString(), "table(resource,permission) init status", 0, false));
    }
}

