/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DataPermissionMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleConditionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.DataPermissionDTO;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.DataPermissionDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.entity.SelectorConditionDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.vo.SelectorConditionVO;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.common.constant.AdminConstants;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SelectorServiceImpl
implements SelectorService {
    private final SelectorMapper selectorMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final PluginMapper pluginMapper;
    private final RuleMapper ruleMapper;
    private final RuleConditionMapper ruleConditionMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final DataPermissionMapper dataPermissionMapper;
    private final UpstreamCheckService upstreamCheckService;

    public SelectorServiceImpl(SelectorMapper selectorMapper, SelectorConditionMapper selectorConditionMapper, PluginMapper pluginMapper, RuleMapper ruleMapper, RuleConditionMapper ruleConditionMapper, ApplicationEventPublisher eventPublisher, DataPermissionMapper dataPermissionMapper, UpstreamCheckService upstreamCheckService) {
        this.selectorMapper = selectorMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.pluginMapper = pluginMapper;
        this.ruleMapper = ruleMapper;
        this.ruleConditionMapper = ruleConditionMapper;
        this.eventPublisher = eventPublisher;
        this.dataPermissionMapper = dataPermissionMapper;
        this.upstreamCheckService = upstreamCheckService;
    }

    @Override
    public String registerDefault(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        List<SelectorConditionDTO> selectorConditionDTOs = selectorDTO.getSelectorConditions();
        if (StringUtils.isEmpty((CharSequence)selectorDTO.getId())) {
            this.selectorMapper.insertSelective(selectorDO);
            selectorConditionDTOs.forEach(selectorConditionDTO -> {
                selectorConditionDTO.setSelectorId(selectorDO.getId());
                this.selectorConditionMapper.insertSelective(SelectorConditionDO.buildSelectorConditionDO(selectorConditionDTO));
            });
        }
        this.publishEvent(selectorDO, selectorConditionDTOs);
        return selectorDO.getId();
    }

    @Override
    public String registerDefault(MetaDataRegisterDTO dto, String pluginName, String selectorHandler) {
        String contextPath = ContextPathUtils.buildContextPath((String)dto.getContextPath(), (String)dto.getAppName());
        SelectorDO selectorDO = this.findByNameAndPluginName(contextPath, pluginName);
        if (Objects.isNull(selectorDO)) {
            return this.registerSelector(contextPath, pluginName, selectorHandler);
        }
        return selectorDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(SelectorDTO selectorDTO) {
        int selectorCount;
        if (Objects.equals(SelectorTypeEnum.CUSTOM_FLOW.getCode(), selectorDTO.getType())) {
            Assert.notNull(selectorDTO.getMatchMode(), "if type is custom, matchMode is not null");
            Assert.notEmpty(selectorDTO.getSelectorConditions(), "if type is custom, selectorConditions is not empty");
        }
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        List<SelectorConditionDTO> selectorConditionDTOs = selectorDTO.getSelectorConditions();
        if (StringUtils.isEmpty((CharSequence)selectorDTO.getId())) {
            selectorCount = this.selectorMapper.insertSelective(selectorDO);
            selectorConditionDTOs.forEach(selectorConditionDTO -> {
                selectorConditionDTO.setSelectorId(selectorDO.getId());
                this.selectorConditionMapper.insertSelective(SelectorConditionDO.buildSelectorConditionDO(selectorConditionDTO));
            });
            if (Boolean.TRUE.equals(this.dataPermissionMapper.existed(JwtUtils.getUserInfo().getUserId()))) {
                DataPermissionDTO dataPermissionDTO = new DataPermissionDTO();
                dataPermissionDTO.setUserId(JwtUtils.getUserInfo().getUserId());
                dataPermissionDTO.setDataId(selectorDO.getId());
                dataPermissionDTO.setDataType(AdminConstants.SELECTOR_DATA_TYPE);
                this.dataPermissionMapper.insertSelective(DataPermissionDO.buildPermissionDO(dataPermissionDTO));
            }
        } else {
            selectorCount = this.selectorMapper.updateSelective(selectorDO);
            this.selectorConditionMapper.deleteByQuery(new SelectorConditionQuery(selectorDO.getId()));
            selectorConditionDTOs.forEach(selectorConditionDTO -> {
                selectorConditionDTO.setSelectorId(selectorDO.getId());
                SelectorConditionDO selectorConditionDO = SelectorConditionDO.buildSelectorConditionDO(selectorConditionDTO);
                this.selectorConditionMapper.insertSelective(selectorConditionDO);
            });
        }
        this.publishEvent(selectorDO, selectorConditionDTOs);
        this.updateDivideUpstream(selectorDO);
        return selectorCount;
    }

    @Override
    public int updateSelective(SelectorDO selectorDO) {
        return this.selectorMapper.updateSelective(selectorDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        Map<String, String> pluginMap;
        Map selectorDOMap;
        List pluginIdList;
        List<PluginDO> pluginDOList;
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        HashSet<String> idSet = new HashSet<String>(ids);
        List<SelectorDO> selectorDOList = this.selectorMapper.selectByIdSet(idSet);
        if (CollectionUtils.isNotEmpty(selectorDOList) && CollectionUtils.isNotEmpty(pluginDOList = this.pluginMapper.selectByIds(new ArrayList<String>(pluginIdList = (selectorDOMap = selectorDOList.stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, Function.identity(), (value1, value2) -> value1))).values().stream().map(SelectorDO::getPluginId).collect(Collectors.toList())))) && (pluginMap = pluginDOList.stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, PluginDO::getName, (value1, value2) -> value1))).size() == pluginIdList.size()) {
            this.selectorMapper.deleteByIds(ids);
            this.selectorConditionMapper.deleteBySelectorIds(ids);
            this.dataPermissionMapper.deleteByDataIdList(ids);
            List selectorDataList = selectorDOMap.values().stream().map(selectorDO -> {
                String pluginName = (String)pluginMap.get(selectorDO.getPluginId());
                if (pluginName.equals(PluginEnum.DIVIDE.getName())) {
                    UpstreamCheckService.removeByKey(selectorDO.getId());
                }
                return SelectorDO.transFrom(selectorDO, pluginName, null);
            }).collect(Collectors.toList());
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.DELETE, selectorDataList));
            List<RuleDO> ruleDOList = this.ruleMapper.findBySelectorIds(ids);
            if (CollectionUtils.isNotEmpty(ruleDOList)) {
                ArrayList<String> ruleIdList = new ArrayList<String>();
                List ruleDataList = ruleDOList.stream().filter(Objects::nonNull).map(ruleDO -> {
                    ruleIdList.add(ruleDO.getId());
                    SelectorDO selectorDO = (SelectorDO)selectorDOMap.get(ruleDO.getSelectorId());
                    String pluginName = (String)pluginMap.get(selectorDO.getPluginId());
                    return RuleDO.transFrom(ruleDO, pluginName, null);
                }).collect(Collectors.toList());
                this.ruleMapper.deleteByIds(ruleIdList);
                this.ruleConditionMapper.deleteByRuleIds(ruleIdList);
                this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.DELETE, ruleDataList));
            }
        }
        return idSet.size();
    }

    @Override
    public SelectorVO findById(String id) {
        return SelectorVO.buildSelectorVO(this.selectorMapper.selectById(id), this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(id)).stream().map(SelectorConditionVO::buildSelectorConditionVO).collect(Collectors.toList()));
    }

    @Override
    public SelectorDO findByName(String name) {
        return this.selectorMapper.selectByName(name);
    }

    @Override
    public SelectorDO findByNameAndPluginName(String name, String pluginName) {
        PluginDO pluginDO = this.pluginMapper.selectByName(pluginName);
        return this.selectorMapper.findByNameAndPluginId(name, pluginDO.getId());
    }

    @Override
    public SelectorData buildByName(String name) {
        return this.buildSelectorData(this.selectorMapper.selectByName(name));
    }

    @Override
    public SelectorData buildByName(String name, String pluginName) {
        return this.buildSelectorData(this.findByNameAndPluginName(name, pluginName));
    }

    @Override
    @DataPermission(dataType="selector")
    @Pageable
    public CommonPager<SelectorVO> listByPage(SelectorQuery selectorQuery) {
        return PageResultUtils.result(selectorQuery.getPageParameter(), () -> this.selectorMapper.selectByQuery(selectorQuery).stream().map(SelectorVO::buildSelectorVO).collect(Collectors.toList()));
    }

    @Override
    public List<SelectorData> findByPluginId(String pluginId) {
        List<SelectorDO> selectorDOList = this.selectorMapper.findByPluginId(pluginId);
        return this.buildSelectorDataList(selectorDOList);
    }

    @Override
    public List<SelectorData> listAll() {
        List<SelectorDO> selectorDOList = this.selectorMapper.selectAll();
        return this.buildSelectorDataList(selectorDOList);
    }

    private void publishEvent(SelectorDO selectorDO, List<SelectorConditionDTO> selectorConditionDTOs) {
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        List<ConditionData> conditionDataList = selectorConditionDTOs.stream().map(ConditionTransfer.INSTANCE::mapToSelectorDTO).collect(Collectors.toList());
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList))));
    }

    private SelectorData buildSelectorData(SelectorDO selectorDO) {
        List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        if (Objects.isNull(pluginDO)) {
            return null;
        }
        return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
    }

    private List<SelectorData> buildSelectorDataList(List<SelectorDO> selectorDOList) {
        Map<String, String> idMap = Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, SelectorDO::getPluginId, (value1, value2) -> value1));
        if (MapUtils.isEmpty(idMap)) {
            return new ArrayList<SelectorData>();
        }
        Map<String, List> selectorConditionMap = Optional.ofNullable(this.selectorConditionMapper.selectBySelectorIds(idMap.keySet())).orElseGet(ArrayList::new).stream().collect(Collectors.toMap(SelectorConditionDO::getSelectorId, selectorConditionDO -> {
            ArrayList<SelectorConditionDO> dataList = new ArrayList<SelectorConditionDO>();
            dataList.add((SelectorConditionDO)selectorConditionDO);
            return dataList;
        }, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }));
        Map pluginDOMap = Optional.ofNullable(this.pluginMapper.selectByIds(Lists.newArrayList(idMap.values()))).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toMap(BaseDO::getId, Function.identity(), (value1, value2) -> value1));
        return Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).map(selectorDO -> {
            String id = selectorDO.getId();
            String pluginId = selectorDO.getPluginId();
            PluginDO pluginDO = (PluginDO)pluginDOMap.get(pluginId);
            if (Objects.isNull(pluginDO)) {
                return null;
            }
            List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS((List)selectorConditionMap.get(id));
            return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
        }).collect(Collectors.toList());
    }

    private void updateDivideUpstream(SelectorDO selectorDO) {
        String handle;
        String selectorId = selectorDO.getId();
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        List existDivideUpstreams = null;
        if (PluginEnum.SPRING_CLOUD.getName().equals(pluginDO.getName())) {
            if (Objects.nonNull(selectorDO.getHandle())) {
                SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)GsonUtils.getInstance().fromJson(selectorDO.getHandle(), SpringCloudSelectorHandle.class);
                existDivideUpstreams = springCloudSelectorHandle.getDivideUpstreams();
            }
        } else if (PluginEnum.DIVIDE.getName().equals(pluginDO.getName()) && StringUtils.isNotBlank((CharSequence)(handle = selectorDO.getHandle()))) {
            existDivideUpstreams = GsonUtils.getInstance().fromList(handle, DivideUpstream.class);
        }
        if (CollectionUtils.isNotEmpty(existDivideUpstreams)) {
            this.upstreamCheckService.replace(selectorId, CommonUpstreamUtils.convertCommonUpstreamList(existDivideUpstreams));
        }
    }

    private String registerSelector(String contextPath, String pluginName, String selectorHandler) {
        SelectorDTO selectorDTO = this.buildSelectorDTO(contextPath, this.pluginMapper.selectByName(pluginName).getId());
        selectorDTO.setHandle(selectorHandler);
        return this.registerDefault(selectorDTO);
    }

    private SelectorDTO buildSelectorDTO(String contextPath, String pluginId) {
        SelectorDTO selectorDTO = this.buildDefaultSelectorDTO(contextPath);
        selectorDTO.setPluginId(pluginId);
        selectorDTO.setSelectorConditions(this.buildDefaultSelectorConditionDTO(contextPath));
        return selectorDTO;
    }

    private SelectorDTO buildDefaultSelectorDTO(String name) {
        return SelectorDTO.builder().name(name).type(SelectorTypeEnum.CUSTOM_FLOW.getCode()).matchMode(MatchModeEnum.AND.getCode()).enabled(Boolean.TRUE).loged(Boolean.TRUE).continued(Boolean.TRUE).sort(1).build();
    }

    private List<SelectorConditionDTO> buildDefaultSelectorConditionDTO(String contextPath) {
        SelectorConditionDTO selectorConditionDTO = new SelectorConditionDTO();
        selectorConditionDTO.setParamType(ParamTypeEnum.URI.getName());
        selectorConditionDTO.setParamName("/");
        selectorConditionDTO.setOperator(OperatorEnum.MATCH.getAlias());
        selectorConditionDTO.setParamValue(contextPath + "/**");
        return Collections.singletonList(selectorConditionDTO);
    }
}

