/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.PermissionMapper;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.model.dto.PermissionDTO;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.entity.PermissionDO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ResourceQuery;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.common.enums.AdminResourceEnum;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceServiceImpl
implements ResourceService {
    private final ResourceMapper resourceMapper;
    private final PermissionMapper permissionMapper;

    public ResourceServiceImpl(ResourceMapper resourceMapper, PermissionMapper permissionMapper) {
        this.resourceMapper = resourceMapper;
        this.permissionMapper = permissionMapper;
    }

    @Override
    public void createResource(ResourceDO resourceDO) {
        this.insertResource(resourceDO);
    }

    @Override
    public int createResourceBatch(List<ResourceDO> resourceDOList) {
        return this.insertResourceBatch(resourceDOList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(ResourceDTO resourceDTO) {
        ResourceDO resourceDO = ResourceDO.buildResourceDO(resourceDTO);
        if (StringUtils.isEmpty((CharSequence)resourceDTO.getId())) {
            return this.insertResource(resourceDO);
        }
        return this.resourceMapper.updateSelective(resourceDO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        int ret = 0;
        List<ResourceVO> resourceVOList = this.resourceMapper.selectAll().stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList());
        List<String> deleteResourceIds = this.getDeleteResourceIds(ids, resourceVOList);
        if (CollectionUtils.isNotEmpty(deleteResourceIds)) {
            this.permissionMapper.deleteByResourceId(deleteResourceIds);
            ret = this.resourceMapper.delete(deleteResourceIds);
        }
        return ret;
    }

    @Override
    public ResourceVO findById(String id) {
        return ResourceVO.buildResourceVO(this.resourceMapper.selectById(id));
    }

    @Override
    public ResourceVO findByTitle(String title) {
        return ResourceVO.buildResourceVO(this.resourceMapper.selectByTitle(title));
    }

    @Override
    public List<ResourceVO> listByTitles(List<String> titles) {
        List<ResourceDO> resources = this.resourceMapper.selectByTitles(titles);
        if (CollectionUtils.isEmpty(resources)) {
            return Collections.emptyList();
        }
        return resources.stream().map(ResourceVO::buildResourceVO).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Pageable
    public CommonPager<ResourceVO> listByPage(ResourceQuery resourceQuery) {
        return PageResultUtils.result(resourceQuery.getPageParameter(), () -> this.resourceMapper.selectByQuery(resourceQuery).stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList()));
    }

    @Override
    public List<PermissionMenuVO.MenuInfo> getMenuTree() {
        List<ResourceVO> resourceVOList = this.resourceMapper.selectAll().stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(resourceVOList)) {
            return null;
        }
        return this.getMenuInfo(resourceVOList);
    }

    @Override
    public List<ResourceVO> findByParentId(String id) {
        return this.resourceMapper.selectByParentId(id).stream().filter(item -> item.getResourceType().equals(AdminResourceEnum.THREE_MENU.getCode())).map(ResourceVO::buildResourceVO).collect(Collectors.toList());
    }

    @Override
    public List<PermissionMenuVO.MenuInfo> getMenuInfo(List<ResourceVO> metaList) {
        ArrayList<PermissionMenuVO.MenuInfo> retList = new ArrayList<PermissionMenuVO.MenuInfo>();
        if (CollectionUtils.isEmpty(metaList)) {
            return retList;
        }
        Map menuInfoMap = metaList.stream().map(PermissionMenuVO.MenuInfo::buildMenuInfo).filter(menuInfo -> Objects.nonNull(menuInfo) && StringUtils.isNotEmpty((CharSequence)menuInfo.getId())).collect(Collectors.toMap(PermissionMenuVO.MenuInfo::getId, Function.identity(), (value1, value2) -> value1));
        Map<String, Set<String>> metaChildrenMap = this.dealChildrenMap(metaList);
        metaChildrenMap.forEach((parent, children) -> {
            PermissionMenuVO.MenuInfo menuInfo = (PermissionMenuVO.MenuInfo)menuInfoMap.get(parent);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                List<PermissionMenuVO.MenuInfo> targetList = Objects.isNull(menuInfo) ? retList : menuInfo.getChildren();
                children.forEach(child -> {
                    PermissionMenuVO.MenuInfo data = (PermissionMenuVO.MenuInfo)menuInfoMap.get(child);
                    if (Objects.nonNull(data)) {
                        targetList.add(data);
                    }
                });
            }
        });
        return retList;
    }

    private Map<String, Set<String>> dealChildrenMap(List<ResourceVO> metaList) {
        return metaList.stream().filter(meta -> Objects.nonNull(meta) && StringUtils.isNotEmpty((CharSequence)meta.getId())).collect(Collectors.toMap(ResourceVO::getParentId, resourceVO -> {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(resourceVO.getId());
            return idSet;
        }, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        }));
    }

    private List<String> getDeleteResourceIds(List<String> resourceIds, List<ResourceVO> metaList) {
        ArrayList<String> deleteResourceIds = null;
        if (CollectionUtils.isEmpty(metaList) || CollectionUtils.isEmpty(resourceIds)) {
            return deleteResourceIds;
        }
        deleteResourceIds = new ArrayList<String>();
        Map metaMap = metaList.stream().filter(Objects::nonNull).collect(Collectors.toMap(ResourceVO::getId, Function.identity(), (value1, value2) -> value1));
        Map<String, Set<String>> metaChildrenMap = this.dealChildrenMap(metaList);
        ArrayDeque<String> cacheDatas = new ArrayDeque<String>(resourceIds);
        while (!cacheDatas.isEmpty()) {
            String resourceId = (String)cacheDatas.pollFirst();
            ResourceVO resourceVO = (ResourceVO)metaMap.get(resourceId);
            Set<String> children = metaChildrenMap.get(resourceId);
            if (Objects.nonNull(resourceVO)) {
                deleteResourceIds.add(resourceVO.getId());
                metaMap.remove(resourceId);
            }
            if (!CollectionUtils.isNotEmpty(children)) continue;
            children.forEach(cacheDatas::addFirst);
            metaChildrenMap.remove(resourceId);
        }
        return deleteResourceIds;
    }

    private int insertResource(ResourceDO resourceDO) {
        this.permissionMapper.insertSelective(PermissionDO.buildPermissionDO(PermissionDTO.builder().objectId("1346358560427216896").resourceId(resourceDO.getId()).build()));
        return this.resourceMapper.insertSelective(resourceDO);
    }

    private int insertResourceBatch(List<ResourceDO> resourceDOList) {
        if (CollectionUtils.isEmpty(resourceDOList)) {
            return 0;
        }
        List<PermissionDO> permissionDOList = resourceDOList.stream().filter(Objects::nonNull).map(resourceDO -> PermissionDO.buildPermissionDO(PermissionDTO.builder().objectId("1346358560427216896").resourceId(resourceDO.getId()).build())).collect(Collectors.toList());
        this.permissionMapper.insertBatch(permissionDOList);
        return this.resourceMapper.insertBatch(resourceDOList);
    }
}

