/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.PluginHandleMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.RuleConditionMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.ResourceDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PluginQuery;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.AdminPluginOperateEnum;
import org.apache.shenyu.common.enums.AdminResourceEnum;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PluginServiceImpl
implements PluginService {
    private final PluginMapper pluginMapper;
    private final PluginHandleMapper pluginHandleMapper;
    private final SelectorMapper selectorMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final RuleMapper ruleMapper;
    private final RuleConditionMapper ruleConditionMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final ResourceService resourceService;

    public PluginServiceImpl(PluginMapper pluginMapper, PluginHandleMapper pluginHandleMapper, SelectorMapper selectorMapper, SelectorConditionMapper selectorConditionMapper, RuleMapper ruleMapper, RuleConditionMapper ruleConditionMapper, ApplicationEventPublisher eventPublisher, ResourceService resourceService) {
        this.pluginMapper = pluginMapper;
        this.pluginHandleMapper = pluginHandleMapper;
        this.selectorMapper = selectorMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.ruleMapper = ruleMapper;
        this.ruleConditionMapper = ruleConditionMapper;
        this.eventPublisher = eventPublisher;
        this.resourceService = resourceService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createOrUpdate(PluginDTO pluginDTO) {
        return PluginService.super.createOrUpdate(pluginDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String create(PluginDTO pluginDTO) {
        Assert.isNull(this.pluginMapper.nameExisted((Serializable)((Object)pluginDTO.getName())), "The plugin name already exists and can't be added repeatedly!");
        PluginDO pluginDO = PluginDO.buildPluginDO(pluginDTO);
        this.insertPluginDataToResource(pluginDTO);
        this.pluginMapper.insertSelective(pluginDO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.CREATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(pluginDO))));
        return "create success";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String update(PluginDTO pluginDTO) {
        Assert.isNull(this.pluginMapper.nameExistedExclude((Serializable)((Object)pluginDTO.getName()), Collections.singletonList(pluginDTO.getId())), "The plugin name already exists and can't be added repeatedly!");
        PluginDO pluginDO = PluginDO.buildPluginDO(pluginDTO);
        this.pluginMapper.updateSelective(pluginDO);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(pluginDO))));
        return "update success";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(List<String> ids) {
        List<ResourceVO> resources;
        List plugins = Optional.ofNullable(this.pluginMapper.selectByIds(ids)).orElse(Collections.emptyList());
        List<String> pluginIds = plugins.stream().map(BaseDO::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pluginIds)) {
            return "The plugin(s) does not exist\uff01";
        }
        this.pluginMapper.deleteByIds(pluginIds);
        this.pluginHandleMapper.deleteByPluginIds(pluginIds);
        List<String> selectorIds = Optional.ofNullable(this.selectorMapper.findByPluginIds(pluginIds)).orElse(Collections.emptyList()).stream().map(BaseDO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(selectorIds)) {
            this.selectorMapper.deleteByIds(selectorIds);
            this.selectorConditionMapper.deleteBySelectorIds(selectorIds);
            List<String> ruleIds = Optional.ofNullable(this.ruleMapper.findBySelectorIds(selectorIds)).orElse(Collections.emptyList()).stream().map(BaseDO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ruleIds)) {
                this.ruleMapper.deleteByIds(ruleIds);
                this.ruleConditionMapper.deleteByRuleIds(ruleIds);
            }
        }
        if (CollectionUtils.isNotEmpty(resources = this.resourceService.listByTitles(plugins.stream().map(PluginDO::getName).collect(Collectors.toList())))) {
            this.resourceService.delete(resources.stream().map(ResourceVO::getId).collect(Collectors.toList()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.DELETE, plugins.stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
        return "";
    }

    @Override
    public String enabled(List<String> ids, Boolean enabled) {
        if (CollectionUtils.isEmpty(ids)) {
            return "The plugin(s) does not exist\uff01";
        }
        List plugins = Optional.ofNullable(this.pluginMapper.selectByIds(ids)).orElseGet(ArrayList::new);
        HashSet<String> idSet = new HashSet<String>(Optional.of(ids).orElseGet(ArrayList::new));
        if (idSet.size() > plugins.size()) {
            return "The plugin(s) does not exist\uff01";
        }
        plugins.forEach(pluginDO -> pluginDO.setEnabled(enabled));
        this.pluginMapper.updateEnableByIdSet(idSet, enabled);
        if (CollectionUtils.isNotEmpty((Collection)plugins)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, plugins.stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList())));
        }
        return "";
    }

    @Override
    public PluginVO findById(String id) {
        return PluginVO.buildPluginVO(this.pluginMapper.selectById(id));
    }

    @Override
    @Pageable
    public CommonPager<PluginVO> listByPage(PluginQuery pluginQuery) {
        return PageResultUtils.result(pluginQuery.getPageParameter(), () -> this.pluginMapper.selectByQuery(pluginQuery).stream().map(PluginVO::buildPluginVO).collect(Collectors.toList()));
    }

    @Override
    public List<PluginData> listAll() {
        return this.pluginMapper.selectAll().stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList());
    }

    @Override
    public List<PluginData> listAllNotInResource() {
        return this.pluginMapper.listAllNotInResource().stream().map(PluginTransfer.INSTANCE::mapToData).collect(Collectors.toList());
    }

    @Override
    public String selectIdByName(String name) {
        PluginDO pluginDO = this.pluginMapper.selectByName(name);
        Objects.requireNonNull(pluginDO);
        return pluginDO.getId();
    }

    @Override
    public PluginDO findByName(String name) {
        return this.pluginMapper.selectByName(name);
    }

    private void insertPluginDataToResource(PluginDTO pluginDTO) {
        ResourceDO resourceDO = ResourceDO.buildResourceDO(ResourceDTO.builder().parentId("1346775491550474240").title(pluginDTO.getName()).name(pluginDTO.getName()).url("/plug/" + pluginDTO.getName()).component(pluginDTO.getName()).resourceType(AdminResourceEnum.SECOND_MENU.getCode()).sort(0).icon("block").isLeaf(Boolean.FALSE).isRoute(0).status(1).perms("").build());
        this.insertPluginMenuResource(resourceDO);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.ADD);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.DELETE);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.EDIT);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.SELECTOR, AdminPluginOperateEnum.QUERY);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.ADD);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.DELETE);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.EDIT);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.RULE, AdminPluginOperateEnum.QUERY);
        this.insertPluginButtonResource(resourceDO.getId(), pluginDTO.getName(), ConfigGroupEnum.PLUGIN, AdminPluginOperateEnum.SYNCHRONIZE);
    }

    private void insertPluginMenuResource(ResourceDO resourceDO) {
        this.resourceService.createResource(resourceDO);
    }

    private void insertPluginButtonResource(String parentId, String pluginName, ConfigGroupEnum configGroupEnum, AdminPluginOperateEnum adminPluginOperateEnum) {
        ResourceDO resourceDO = ResourceDO.buildResourceDO(ResourceDTO.builder().parentId(parentId).name("").url("").component("").resourceType(AdminResourceEnum.THREE_MENU.getCode()).isLeaf(Boolean.TRUE).status(1).sort(0).icon("").isRoute(0).build());
        switch (configGroupEnum) {
            case SELECTOR: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + ConfigGroupEnum.SELECTOR.name() + "." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + "Selector:" + adminPluginOperateEnum.getName());
                break;
            }
            case RULE: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + ConfigGroupEnum.RULE.name() + "." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + "Rule:" + adminPluginOperateEnum.getName());
                break;
            }
            case PLUGIN: {
                resourceDO.setTitle("SHENYU.BUTTON.PLUGIN." + adminPluginOperateEnum.name());
                resourceDO.setPerms("plugin:" + pluginName + ":" + adminPluginOperateEnum.getName());
                break;
            }
        }
        this.insertPluginMenuResource(resourceDO);
    }
}

