/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.PluginHandleMapper;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.PluginHandleDTO;
import org.apache.shenyu.admin.model.entity.PluginHandleDO;
import org.apache.shenyu.admin.model.entity.ShenyuDictDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PluginHandleQuery;
import org.apache.shenyu.admin.model.vo.PluginHandleVO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.PluginHandleService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PluginHandleServiceImpl
implements PluginHandleService {
    private static final int SELECT_BOX_DATA_TYPE = 3;
    private final PluginHandleMapper pluginHandleMapper;
    private final ShenyuDictMapper shenyuDictMapper;

    public PluginHandleServiceImpl(PluginHandleMapper pluginHandleMapper, ShenyuDictMapper shenyuDictMapper) {
        this.pluginHandleMapper = pluginHandleMapper;
        this.shenyuDictMapper = shenyuDictMapper;
    }

    @Override
    @Pageable
    public CommonPager<PluginHandleVO> listByPage(PluginHandleQuery pluginHandleQuery) {
        List pluginHandleDOList = Optional.ofNullable(this.pluginHandleMapper.selectByQuery(pluginHandleQuery)).orElseGet(ArrayList::new);
        return PageResultUtils.result(pluginHandleQuery.getPageParameter(), () -> this.buildPluginHandleVO(pluginHandleDOList));
    }

    @Override
    public Integer createOrUpdate(PluginHandleDTO pluginHandleDTO) {
        PluginHandleDO pluginHandleDO = PluginHandleDO.buildPluginHandleDO(pluginHandleDTO);
        int pluginHandleCount = StringUtils.isEmpty((CharSequence)pluginHandleDTO.getId()) ? this.pluginHandleMapper.insertSelective(pluginHandleDO) : this.pluginHandleMapper.updateByPrimaryKeySelective(pluginHandleDO);
        return pluginHandleCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deletePluginHandles(List<String> ids) {
        int ret = 0;
        HashSet<String> idSet = new HashSet<String>(Optional.ofNullable(ids).orElseGet(ArrayList::new));
        if (CollectionUtils.isNotEmpty(idSet)) {
            ret = this.pluginHandleMapper.deleteByIdSet(idSet);
        }
        return ret;
    }

    @Override
    public PluginHandleVO findById(String id) {
        return this.buildPluginHandleVO(this.pluginHandleMapper.selectById(id));
    }

    @Override
    public List<PluginHandleVO> list(String pluginId, Integer type) {
        PluginHandleQuery pluginHandleQuery = PluginHandleQuery.builder().pluginId(pluginId).type(type).build();
        List pluginHandleDOList = Optional.ofNullable(this.pluginHandleMapper.selectByQuery(pluginHandleQuery)).orElseGet(ArrayList::new);
        return this.buildPluginHandleVO(pluginHandleDOList);
    }

    private PluginHandleVO buildPluginHandleVO(PluginHandleDO pluginHandleDO) {
        List dictOptions = null;
        if (pluginHandleDO.getDataType() == 3) {
            dictOptions = this.shenyuDictMapper.findByType(pluginHandleDO.getField()).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toList());
        }
        return PluginHandleVO.buildPluginHandleVO(pluginHandleDO, dictOptions);
    }

    private List<PluginHandleVO> buildPluginHandleVO(List<PluginHandleDO> pluginHandleDOList) {
        Set<String> fieldSet = pluginHandleDOList.stream().filter(pluginHandleDO -> pluginHandleDO.getDataType() == 3).map(PluginHandleDO::getField).collect(Collectors.toSet());
        HashMap<String, ArrayList> shenyuDictDOMap = new HashMap<String, ArrayList>();
        if (CollectionUtils.isNotEmpty(fieldSet)) {
            List<ShenyuDictDO> shenyuDictDOList = this.shenyuDictMapper.findByTypeBatch(fieldSet);
            shenyuDictDOMap.putAll(Optional.ofNullable(shenyuDictDOList).orElseGet(ArrayList::new).stream().map(ShenyuDictVO::buildShenyuDictVO).collect(Collectors.toMap(ShenyuDictVO::getType, xva$0 -> Lists.newArrayList((Object[])new ShenyuDictVO[]{xva$0}), (list1, list2) -> {
                list1.addAll(list2);
                return list1;
            })));
        }
        return pluginHandleDOList.stream().map(pluginHandleDO -> {
            List dictOptions = (List)shenyuDictDOMap.get(pluginHandleDO.getField());
            return PluginHandleVO.buildPluginHandleVO(pluginHandleDO, dictOptions);
        }).collect(Collectors.toList());
    }
}

