/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.DashboardUserMapper;
import org.apache.shenyu.admin.mapper.PermissionMapper;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.mapper.UserRoleMapper;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shenyu.admin.model.entity.PermissionDO;
import org.apache.shenyu.admin.model.entity.UserRoleDO;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.PermissionService;
import org.apache.shenyu.admin.service.ResourceService;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.common.constant.ResourceTypeConstants;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionService {
    private final DashboardUserMapper dashboardUserMapper;
    private final UserRoleMapper userRoleMapper;
    private final PermissionMapper permissionMapper;
    private final ResourceMapper resourceMapper;
    private final ResourceService resourceService;

    public PermissionServiceImpl(DashboardUserMapper dashboardUserMapper, UserRoleMapper userRoleMapper, PermissionMapper permissionMapper, ResourceMapper resourceMapper, ResourceService resourceService) {
        this.dashboardUserMapper = dashboardUserMapper;
        this.userRoleMapper = userRoleMapper;
        this.permissionMapper = permissionMapper;
        this.resourceMapper = resourceMapper;
        this.resourceService = resourceService;
    }

    @Override
    public PermissionMenuVO getPermissionMenu(String token) {
        UserInfo userInfo = JwtUtils.getUserInfo();
        if (Objects.isNull(userInfo)) {
            return null;
        }
        List<ResourceVO> resourceVOList = this.getResourceListByUserName(userInfo.getUserName());
        if (CollectionUtils.isEmpty(resourceVOList)) {
            return null;
        }
        List<PermissionMenuVO.MenuInfo> menuInfoList = this.resourceService.getMenuInfo(resourceVOList);
        return new PermissionMenuVO(menuInfoList, this.getAuthPerm(resourceVOList), this.getAllAuthPerms());
    }

    @Override
    public Set<String> getAuthPermByUserName(String userName) {
        List<ResourceVO> resourceVOList = this.getResourceListByUserName(userName);
        if (CollectionUtils.isNotEmpty(resourceVOList)) {
            return this.getAuthPerm(resourceVOList).stream().map(PermissionMenuVO.AuthPerm::getPerms).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private List<ResourceVO> getResourceListByUserName(String userName) {
        List<UserRoleDO> userRoleDOList = this.userRoleMapper.findByUserId(this.dashboardUserMapper.selectByUserName(userName).getId());
        List<String> roleIds = userRoleDOList.stream().filter(Objects::nonNull).map(UserRoleDO::getRoleId).collect(Collectors.toList());
        Set<String> resourceIds = this.permissionMapper.findByObjectIds(roleIds).stream().map(PermissionDO::getResourceId).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(resourceIds)) {
            return Collections.emptyList();
        }
        return Optional.ofNullable(this.resourceMapper.selectByIdsBatch(resourceIds)).orElseGet(ArrayList::new).stream().map(ResourceVO::buildResourceVO).collect(Collectors.toList());
    }

    private List<PermissionMenuVO.AuthPerm> getAuthPerm(List<ResourceVO> resourceVOList) {
        return resourceVOList.stream().filter(item -> item.getResourceType().equals(ResourceTypeConstants.MENU_TYPE_2)).map(PermissionMenuVO.AuthPerm::buildAuthPerm).collect(Collectors.toList());
    }

    private List<PermissionMenuVO.AuthPerm> getAllAuthPerms() {
        return this.resourceMapper.selectByResourceType(ResourceTypeConstants.MENU_TYPE_2).stream().map(item -> PermissionMenuVO.AuthPerm.buildAuthPerm(ResourceVO.buildResourceVO(item))).collect(Collectors.toList());
    }
}

