/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.JwtProperties;
import org.apache.shenyu.admin.config.properties.LdapProperties;
import org.apache.shenyu.admin.config.properties.SecretProperties;
import org.apache.shenyu.admin.mapper.DashboardUserMapper;
import org.apache.shenyu.admin.mapper.DataPermissionMapper;
import org.apache.shenyu.admin.mapper.RoleMapper;
import org.apache.shenyu.admin.mapper.UserRoleMapper;
import org.apache.shenyu.admin.model.dto.DashboardUserDTO;
import org.apache.shenyu.admin.model.dto.UserRoleDTO;
import org.apache.shenyu.admin.model.entity.DashboardUserDO;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.entity.UserRoleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.DashboardUserQuery;
import org.apache.shenyu.admin.model.vo.DashboardUserEditVO;
import org.apache.shenyu.admin.model.vo.DashboardUserVO;
import org.apache.shenyu.admin.model.vo.LoginDashboardUserVO;
import org.apache.shenyu.admin.model.vo.RoleVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.transfer.DashboardUserTransfer;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.common.utils.ShaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardUserServiceImpl
implements DashboardUserService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardUserServiceImpl.class);
    private final SecretProperties secretProperties;
    private final DashboardUserMapper dashboardUserMapper;
    private final UserRoleMapper userRoleMapper;
    private final RoleMapper roleMapper;
    private final DataPermissionMapper dataPermissionMapper;
    @Nullable
    private final LdapProperties ldapProperties;
    @Nullable
    private final LdapTemplate ldapTemplate;
    private final JwtProperties jwtProperties;

    public DashboardUserServiceImpl(SecretProperties secretProperties, DashboardUserMapper dashboardUserMapper, UserRoleMapper userRoleMapper, RoleMapper roleMapper, DataPermissionMapper dataPermissionMapper, @Nullable LdapProperties ldapProperties, @Nullable LdapTemplate ldapTemplate, JwtProperties jwtProperties) {
        this.secretProperties = secretProperties;
        this.dashboardUserMapper = dashboardUserMapper;
        this.userRoleMapper = userRoleMapper;
        this.roleMapper = roleMapper;
        this.dataPermissionMapper = dataPermissionMapper;
        this.ldapProperties = ldapProperties;
        this.ldapTemplate = ldapTemplate;
        this.jwtProperties = jwtProperties;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(DashboardUserDTO dashboardUserDTO) {
        DashboardUserDO dashboardUserDO = DashboardUserDO.buildDashboardUserDO(dashboardUserDTO);
        if (StringUtils.isEmpty((CharSequence)dashboardUserDTO.getId())) {
            this.bindUserRole(dashboardUserDO.getId(), dashboardUserDTO.getRoles());
            return this.dashboardUserMapper.insertSelective(dashboardUserDO);
        }
        if (CollectionUtils.isNotEmpty(dashboardUserDTO.getRoles())) {
            if (!"admin".equals(dashboardUserDTO.getUserName())) {
                this.userRoleMapper.deleteByUserId(dashboardUserDTO.getId());
            }
            this.bindUserRole(dashboardUserDTO.getId(), dashboardUserDTO.getRoles());
        }
        return this.dashboardUserMapper.updateSelective(dashboardUserDO);
    }

    @Override
    public int delete(List<String> ids) {
        int ret = 0;
        if (CollectionUtils.isNotEmpty(ids)) {
            Set<String> idSet = Optional.of(ids).orElseGet(ArrayList::new).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            DashboardUserDO dashboardUserDO = this.dashboardUserMapper.selectByUserName("admin");
            if (Objects.nonNull(dashboardUserDO)) {
                idSet.remove(dashboardUserDO.getId());
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                ret = this.dashboardUserMapper.deleteByIdSet(idSet);
                this.userRoleMapper.deleteByUserIdSet(idSet);
                this.dataPermissionMapper.deleteByUserIdSet(idSet);
            }
        }
        return ret;
    }

    @Override
    public DashboardUserEditVO findById(String id) {
        DashboardUserVO dashboardUserVO = DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.selectById(id));
        Set roleIdSet = Optional.ofNullable(this.userRoleMapper.findByUserId(id)).orElseGet(ArrayList::new).stream().map(UserRoleDO::getRoleId).collect(Collectors.toSet());
        List allRoleDOList = Optional.ofNullable(this.roleMapper.selectAll()).orElseGet(ArrayList::new);
        List<RoleVO> allRoles = allRoleDOList.stream().map(RoleVO::buildRoleVO).collect(Collectors.toList());
        List roleDOList = allRoleDOList.stream().filter(roleDO -> roleIdSet.contains(roleDO.getId())).collect(Collectors.toList());
        List<RoleVO> roles = Optional.of(roleDOList).orElseGet(ArrayList::new).stream().map(RoleVO::buildRoleVO).filter(Objects::nonNull).collect(Collectors.toList());
        return DashboardUserEditVO.buildDashboardUserEditVO(dashboardUserVO, roles, allRoles);
    }

    @Override
    public DashboardUserVO findByQuery(String userName, String password) {
        return DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.findByQuery(userName, password));
    }

    @Override
    public DashboardUserVO findByUserName(String userName) {
        return DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.selectByUserName(userName));
    }

    @Override
    public CommonPager<DashboardUserVO> listByPage(DashboardUserQuery dashboardUserQuery) {
        return PageResultUtils.result(dashboardUserQuery.getPageParameter(), () -> this.dashboardUserMapper.countByQuery(dashboardUserQuery), () -> this.dashboardUserMapper.selectByQuery(dashboardUserQuery).stream().map(DashboardUserVO::buildDashboardUserVO).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public LoginDashboardUserVO login(String userName, String password) {
        DashboardUserVO dashboardUserVO = null;
        if (Objects.nonNull(this.ldapTemplate)) {
            dashboardUserVO = this.loginByLdap(userName, password);
        }
        if (Objects.isNull(dashboardUserVO)) {
            dashboardUserVO = this.loginByDatabase(userName, password);
        }
        LoginDashboardUserVO loginDashboardUserVO = LoginDashboardUserVO.buildLoginDashboardUserVO(dashboardUserVO);
        DashboardUserVO finalDashboardUserVO = dashboardUserVO;
        return Optional.ofNullable(loginDashboardUserVO).map(loginUser -> {
            if (Boolean.FALSE.equals(loginUser.getEnabled())) {
                return loginUser;
            }
            return loginUser.setToken(JwtUtils.generateToken(finalDashboardUserVO.getUserName(), finalDashboardUserVO.getPassword(), this.jwtProperties.getExpiredSeconds()));
        }).orElse(null);
    }

    private DashboardUserVO loginByLdap(String userName, String password) {
        String searchBase = String.format("%s=%s,%s", this.ldapProperties.getLoginField(), LdapEncoder.nameEncode((String)userName), this.ldapProperties.getBaseDn());
        String filter = String.format("(objectClass=%s)", this.ldapProperties.getObjectClass());
        try {
            DashboardUserVO dashboardUserVO = null;
            if (this.ldapTemplate.authenticate(searchBase, filter, password) && Objects.isNull(dashboardUserVO = this.findByUserName(userName))) {
                RoleDO role = this.roleMapper.findByRoleName("default");
                DashboardUserDTO dashboardUserDTO = DashboardUserDTO.builder().userName(userName).password(ShaUtils.shaEncryption((String)password)).role(1).roles(Lists.newArrayList((Object[])new String[]{role.getId()})).enabled(true).build();
                this.createOrUpdate(dashboardUserDTO);
                dashboardUserVO = DashboardUserTransfer.INSTANCE.transferDTO2VO(dashboardUserDTO);
            }
            return dashboardUserVO;
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error("ldap verify error.", (Throwable)e);
            return null;
        }
    }

    private DashboardUserVO loginByDatabase(String userName, String password) {
        return this.findByQuery(userName, ShaUtils.shaEncryption((String)password));
    }

    private void bindUserRole(String userId, List<String> roleIds) {
        List<UserRoleDO> userRoleDOList = Optional.ofNullable(roleIds).orElseGet(ArrayList::new).stream().map(roleId -> UserRoleDO.buildUserRoleDO(UserRoleDTO.builder().userId(userId).roleId((String)roleId).build())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userRoleDOList)) {
            return;
        }
        this.userRoleMapper.insertBatch(userRoleDOList);
    }
}

