/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.result;

import java.io.Serializable;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public class ShenyuAdminResult
implements Serializable {
    private static final long serialVersionUID = -2792556188993845048L;
    private Integer code;
    private String message;
    private Object data;

    public ShenyuAdminResult() {
    }

    public ShenyuAdminResult(Integer code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static ShenyuAdminResult success() {
        return ShenyuAdminResult.success("");
    }

    public static ShenyuAdminResult success(String msg) {
        return ShenyuAdminResult.success(msg, null);
    }

    public static ShenyuAdminResult success(Object data) {
        return ShenyuAdminResult.success(null, data);
    }

    public static ShenyuAdminResult success(String msg, Object data) {
        return ShenyuAdminResult.get(200, msg, data);
    }

    public static ShenyuAdminResult error(String msg) {
        return ShenyuAdminResult.error(500, msg);
    }

    public static ShenyuAdminResult error(int code, String msg) {
        return ShenyuAdminResult.get(code, msg, null);
    }

    public static ShenyuAdminResult timeout(String msg) {
        return ShenyuAdminResult.error(HttpStatus.REQUEST_TIMEOUT.value(), msg);
    }

    private static ShenyuAdminResult get(int code, String msg, Object data) {
        return new ShenyuAdminResult(code, msg, data);
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return "ShenyuAdminResult{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShenyuAdminResult)) {
            return false;
        }
        ShenyuAdminResult that = (ShenyuAdminResult)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.message, that.message) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.data);
    }
}

