/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Objects;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class NacosDataInit
implements CommandLineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(NacosDataInit.class);
    private final ConfigService configService;
    private final SyncDataService syncDataService;

    public NacosDataInit(ConfigService configService, SyncDataService syncDataService) {
        this.configService = configService;
        this.syncDataService = syncDataService;
    }

    public void run(String ... args) {
        if (this.dataIdNotExist("shenyu.plugin.json") && this.dataIdNotExist("shenyu.auth.json") && this.dataIdNotExist("shenyu.meta.json")) {
            this.syncDataService.syncAll(DataEventTypeEnum.REFRESH);
        }
    }

    private boolean dataIdNotExist(String pluginDataId) {
        try {
            return Objects.isNull(this.configService.getConfig(pluginDataId, "DEFAULT_GROUP", 6000L));
        }
        catch (NacosException e) {
            LOG.error("Get data from nacos error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }
}

