/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.mapper.ShenyuDictMapper;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ShenyuDictQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/shenyu-dict"})
public class ShenyuDictController {
    private final ShenyuDictService shenyuDictService;

    public ShenyuDictController(ShenyuDictService shenyuDictService) {
        this.shenyuDictService = shenyuDictService;
    }

    @GetMapping(value={""})
    @RequiresPermissions(value={"system:dict:list"})
    public ShenyuAdminResult queryDicts(String type, String dictCode, String dictName, @NotNull Integer currentPage, @NotNull Integer pageSize) {
        ShenyuDictQuery query = new ShenyuDictQuery(type, dictCode, dictName, new PageParameter(currentPage, pageSize));
        return ShenyuAdminResult.success("query success", this.shenyuDictService.listByPage(query));
    }

    @GetMapping(value={"/all/{type}"})
    @RequiresPermissions(value={"system:dict:list"})
    public ShenyuAdminResult findByType(@PathVariable(value="type") String type) {
        return ShenyuAdminResult.success("query success", this.shenyuDictService.list(type));
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:dict:edit"})
    public ShenyuAdminResult detail(@PathVariable(value="id") @Valid @Existed(provider=ShenyuDictMapper.class, message="dict is not existed") @Valid @Existed(provider=ShenyuDictMapper.class, message="dict is not existed") String id) {
        return ShenyuAdminResult.success("detail success", this.shenyuDictService.findById(id));
    }

    @PostMapping(value={""})
    @RequiresPermissions(value={"system:dict:add", "system:dict:edit"}, logical=Logical.OR)
    public ShenyuAdminResult createShenyuDict(@Valid @RequestBody ShenyuDictDTO shenyuDictDTO) {
        return ShenyuAdminResult.success("create success", this.shenyuDictService.createOrUpdate(shenyuDictDTO));
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:dict:edit"})
    public ShenyuAdminResult updateShenyuDict(@PathVariable(value="id") @Valid @Existed(provider=ShenyuDictMapper.class, message="dict is not existed") @Valid @Existed(provider=ShenyuDictMapper.class, message="dict is not existed") String id, @Valid @NotNull @RequestBody ShenyuDictDTO shenyuDictDTO) {
        shenyuDictDTO.setId(id);
        return ShenyuAdminResult.success("update success", this.shenyuDictService.createOrUpdate(shenyuDictDTO));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:dict:delete"})
    public ShenyuAdminResult deleteShenyuDicts(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("delete success", this.shenyuDictService.deleteShenyuDicts(ids));
    }

    @PostMapping(value={"/batchEnabled"})
    @RequiresPermissions(value={"system:dict:disable"})
    public ShenyuAdminResult batchEnabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        Integer result = this.shenyuDictService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        return ShenyuAdminResult.success("batch enable success", result);
    }
}

